/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.gui.ant;

import java.io.PrintWriter;
import java.util.Enumeration;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;

import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.NewObjectNameStepOperator;
import org.netbeans.jellytools.NewWizardOperator;
import org.netbeans.jellytools.RepositoryTabOperator;
import org.netbeans.jellytools.TargetLocationStepOperator;

import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.FolderNode;

import org.netbeans.jellytools.actions.NewTemplateAction;


/** 
 *
 * @author
 * @version
 */
   
public class TestUtilities extends Object {
    
    /** Creates new utilities */
    public TestUtilities() {
    }
    
    /** Find file object by name and extension.
     * @param _pack package name
     * @param _name file name
     * @param _extension file extension
     * @return finded file object or null
     */
    public static FileObject findFileObject(String _package, String _name, String _extension) {
        FileObject f = Repository.getDefault().find(_package, _name, _extension);
        return f;
    }   
     
    /** Find file system name.
     * @param _package package name
     * @param fileName file name
     * @param fileExtension file extension
     * @throws FileStateInvalidException 
     * @return  full FileSystem name  
     */    
    public static String getFS(String _package, String fileName, String fileExtension){
        FileObject f = findFileObject(_package, fileName, fileExtension);
        
        if(f == null)
            throw new JemmyException("Unable find file " + fileName + "." + fileExtension + " in package " + _package);
        
        String fs;
        try {
            fs = f.getFileSystem().getSystemName();
        } catch(FileStateInvalidException exc){
            throw new JemmyException("FileStateInvalidException during attempt get filesystem name for " + fileName + "." + fileExtension + " in package " + _package);
        }
        
        // hack for Win NT/2K , where in FileObject is bad file separator !!!
        char fileSeparator = System.getProperty("file.separator").charAt(0);
        String fsName = fs.replace('/',fileSeparator).replace('\\',fileSeparator);
        //String path = fsName+ ", " + _package + ", " + fileName;
        
        return fsName;
    }        
    
    public static String getCommonMountPath(String pkg, String fl) {
        return getPath(pkg, fl, null, "|");
    }
    
    public static String getMountPointForPkg(String pkg) {
        return getFS(pkg, null, null);
    }
    
    public static Enumeration getMountedFS() {
        return Repository.getDefault().getFileSystems();
    }
    
    public static void mountFS(Enumeration enum) {
        Repository ideRep = Repository.getDefault();
        org.openide.filesystems.FileSystem fs = null;
        while(enum.hasMoreElements()) {
            fs = (org.openide.filesystems.FileSystem)enum.nextElement();
            ideRep.addFileSystem(fs);
        }
        // wait some time to assure Filesystems in Explorer are refreshed        
        new EventTool().waitNoEvent(1000);
    }
    
    public static String getPath(String packageName, String fileName, String fileExtension, String delim){
        String FS_Name = getFS(packageName, fileName, fileExtension);
        return FS_Name + delim + packageName.replace('.',delim.charAt(0)) + delim + fileName;
    }

    public static String getSystemPath(String packageName, String fileName, String fileExtension){
        String fileSeparator = System.getProperty("file.separator");
        return getPath(packageName, fileName, fileExtension, fileSeparator) + "." + fileExtension;
    }

    public static void newFromTemplate(String fileName, String editorName, String path) {
        
        String scriptName = Bundle.getString("org.apache.tools.ant.module.resources.Bundle", 
                                             "Templates/Ant/" + fileName);
        String scriptPath = Bundle.getString("org.apache.tools.ant.module.resources.Bundle", 
                                             "Templates/Ant") + "|" + scriptName;
     
//        System.out.println("MountPointForPkg -> " + TestUtilities.getMountPointForPkg("org.netbeans.test.gui.ant") + " <-");
        
        new Node(new RepositoryTabOperator().getRootNode(), TestUtilities.getMountPointForPkg("org.netbeans.test.gui.ant")+"|"+"Output").select();

//        System.out.println("PATH -> " + path + " <-");
        
        
        NewWizardOperator.create(scriptPath, path, editorName);
        
        // to wait or not to wait ???
        new EventTool().waitNoEvent(1000);
        
        // check Main is opened in Editor
        new EditorOperator(editorName);
        
    }

}
