/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.project;

import org.netbeans.modules.apisupport.project.NbModuleTypeProvider.NbModuleType;

/**
 * Interface to be implemented by NetBeans modules. In the meantime provides
 * information about the type of a module.
 *
 * @see org.netbeans.api.project.Project#getLookup
 * @author Martin Krauskopf
 */
public interface NbModuleTypeProvider {
    
    NbModuleType STANDALONE = new NbModuleType("Standalone Module"); // NOI18N
    NbModuleType SUITE_COMPONENT = new NbModuleType("Suite Component Module"); // NOI18N
    NbModuleType NETBEANS_ORG = new NbModuleType("NetBeans.org Module"); // NOI18N
    
    /** Used for a type-safe enumeration of NetBeans module types. */
    final class NbModuleType {
        
        /** Human readable description of this type utilized by toString. */
        private final String description;
        
        /** Prevents creating of instances. Use constants instead. */
        private NbModuleType(String description) {
            this.description = description;
        }
        
        public String toString() {
            return description;
        }
    }
    
    /** Returns type of this NetBeans module. */
    NbModuleType getModuleType();
}
