/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/**
 *
 * @author Radek Matous
 */
public final class LibrariesModel extends AbstractListModel implements ComboBoxModel, PropertyChangeListener {
    private Library[] cache;
    private Object selectedLibrary = null;
    
    public static JComboBox getComboBox() {
        JComboBox librariesComboBox = new JComboBox(new LibrariesModel());
        librariesComboBox.setRenderer(new LibraryRenderer());
        return librariesComboBox;
    }
    
    /** Creates a new instance of LibrariesModels */
    private LibrariesModel() {
        LibraryManager manager = LibraryManager.getDefault();
        manager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class,
                this, manager));
        Library[] libraries =  getLibraries();
        if (libraries != null && libraries.length > 0) {
            selectedLibrary =  libraries[0];
        }
        
    }
    
    public synchronized int getSize() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache.length;
    }
    
    public synchronized Object getElementAt(int index) {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        if (index >= 0 && index < this.cache.length) {
            return this.cache[index];
        } else {
            return null;
        }
    }
    
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        int oldSize = this.cache == null ? 0 : this.cache.length;
        this.cache = createLibraries();
        int newSize = this.cache.length;
        
        this.fireContentsChanged(this, 0, Math.min(oldSize-1,newSize-1));
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this,newSize,oldSize-1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this,oldSize,newSize-1);
        }
    }
    
    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            this.cache = this.createLibraries();
        }
        return this.cache;
    }
    
    private Library[] createLibraries() {
        Library[] libs = LibraryManager.getDefault().getLibraries();
        Arrays.sort(libs, new Comparator() {
            public int compare(Object o1, Object o2) {
                assert (o1 instanceof Library) && (o2 instanceof Library);
                String name1 = ((Library)o1).getDisplayName();
                String name2 = ((Library)o2).getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return libs;
    }
        
    public void setSelectedItem(Object libarry) {
        assert libarry == null || libarry instanceof Library;
        if (selectedLibrary != libarry) {
            selectedLibrary = libarry;
            fireContentsChanged(this, -1, -1);
        }
    }
    
    public Object getSelectedItem() {
        return selectedLibrary;
    }
    
    private static final class LibraryRenderer extends DefaultListCellRenderer {
        private static final String LIBRARY_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";  //NOI18N               
        private Icon cachedIcon;
        
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = null;
            /*
            String toolTip = null;
            Color color = null;
             */
            if (value instanceof Library) {
                Library lib = ((Library)value);
                displayName = lib.getDisplayName();
            }
            super.getListCellRendererComponent(list, displayName, index, isSelected, cellHasFocus);
            setIcon(createIcon());
            return this;
        }
        
        private synchronized Icon createIcon () {
            if (this.cachedIcon == null) {
                Image img = Utilities.loadImage(LIBRARY_ICON);
                this.cachedIcon = new ImageIcon (img);
            }                
            return this.cachedIcon;
        }                        
    }
}
