/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/**
 *
 * @author musilt2, pzajac
 */

// list of components:
//[ideTestRunner] Category:Versioning
//[ideTestRunner] AN="Code Name Base:"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="Code Name Base:"
//[ideTestRunner] AC="class javax.swing.JTextField"
//[ideTestRunner] AN="Major Release Version:"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="Major Release Version:"
//[ideTestRunner] AC="class javax.swing.JTextField"
//[ideTestRunner] AN="Specification Version:"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="Specification Version:"
//[ideTestRunner] AC="class javax.swing.JTextField"
//[ideTestRunner] AN="Implementation Version"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="Module Type:"
//[ideTestRunner] AC="class javax.swing.JTextField"
//[ideTestRunner] AN="Provided Tokens:"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="Provided Tokens:"
//[ideTestRunner] AC="class javax.swing.JTextField"
//[ideTestRunner] AN="Append Implementation Versions Automatically"
//[ideTestRunner] AC="class javax.swing.JCheckBox"
//[ideTestRunner] AN="Public Packages:"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.CellRendererPane"
//[ideTestRunner] AN="Public Packages:"
//[ideTestRunner] AC="class javax.swing.JTable"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JViewport"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JScrollPane$ScrollBar"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JScrollPane$ScrollBar"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JViewport"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JScrollPane"
//[ideTestRunner] AN="Add..."
//[ideTestRunner] AC="class javax.swing.JButton"
//[ideTestRunner] AN="Remove"
//[ideTestRunner] AC="class javax.swing.JButton"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JPanel"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.CellRendererPane"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JList"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JViewport"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JScrollPane$ScrollBar"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN=""
//[ideTestRunner] AC="class javax.swing.plaf.metal.MetalScrollButton"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JScrollPane$ScrollBar"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JScrollPane"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JPanel"
//[ideTestRunner] AN="Export Packages Only to Friends:"
//[ideTestRunner] AC="class javax.swing.JCheckBox"
//[ideTestRunner] AN="Regular"
//[ideTestRunner] AC="class javax.swing.JRadioButton"
//[ideTestRunner] AN="Autoload"
//[ideTestRunner] AC="class javax.swing.JRadioButton"
//[ideTestRunner] AN="Eager"
//[ideTestRunner] AC="class javax.swing.JRadioButton"
//[ideTestRunner] AN="Module Type:"
//[ideTestRunner] AC="class javax.swing.JLabel"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class javax.swing.JPanel"
//[ideTestRunner] AN="null"
//[ideTestRunner] AC="class org.netbeans.modules.apisupport.project.ui.customizer.CustomizerVersioning"


package org.netbeans.modules.apisupport.project;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openide.filesystems.FileObject;

public class PCAPIVersioningTest extends ProjectCustomizerHid{

    private static final String CODE_NAME_BASE_NAME = "Code Name Base:";
    private static final Class CODE_NAME_BASE_CLASS = javax.swing.JTextField.class;
    
    private static final String MAJOR_RELEASE_VERSION_NAME = "Major Release Version:";
    private static final Class MAJOR_RELEASE_VERSION_CLASS = javax.swing.JTextField.class;

    private static final String SPECIFICATION_VERSION_NAME = "Specification Version:";
    private static final Class SPECIFICATION_VERSION_CLASS = javax.swing.JTextField.class;
    
    private static final String IMPLEMENTATION_VERSION_NAME = "Implementation Version:";
    private static final Class IMPLEMENTATION_VERSION_CLASS = javax.swing.JTextField.class;
    
    private static final String REGULAR_NAME = "Regular";
    private static final String AUTOLOAD_NAME = "Autoload";
    private static final String EAGER_NAME = "Eager";
    private static final Class MODULE_TYPE_CLASS = javax.swing.JRadioButton.class;
    
    private static final String PROVIDED_TOKENS_NAME = "Provided Tokens:";
    private static final Class PROVIDED_TOKENS_CLASS = javax.swing.JTextField.class;
    
    
    /** Creates a new instance of PCAPIVersioningTest */
    public PCAPIVersioningTest(String name) {
        super(name,"Versioning","standalone");
    }
    
    public void testCodeNameBase() throws Exception {

        // showComponents(); 
        // test if code name base is correct and no editable, then check in manifest
        JTextField cnb = (JTextField) getComponent(CODE_NAME_BASE_NAME, CODE_NAME_BASE_CLASS);
        assertEquals("Should be standalone","standalone",cnb.getText());
        assertFalse(cnb.isEditable());
        
        
        ManifestManager mm = ManifestManager.getInstance(getProject().getManifest(), false);
        String cnbM = mm.getCodeNameBase();
        assertEquals("checkin code name base in file", "standalone", cnbM);
        
    }
  
    public void testMajorReleaseVersion() throws Exception {
        // check default major rel. version in customizer and in file
        JTextField mrv = (JTextField) getComponent(MAJOR_RELEASE_VERSION_NAME, MAJOR_RELEASE_VERSION_CLASS);
        assertEquals("Should be blank by default","", mrv.getText());
        
        ManifestManager mm = ManifestManager.getInstance(getProject().getManifest(), false);
        String mrvM = mm.getReleaseVersion();
        assertNull("checking default major release version in file", mrvM);
        
        //set it to "1" and check in customizer and in manifest.        
        mrv.setText("1");
        okButton();
        openCustomizer();
        assertEquals("major rel version set to 1", "1", mrv.getText());
        
        mm = ManifestManager.getInstance(getProject().getManifest(), false);
        mrvM = mm.getReleaseVersion();
        assertEquals("major rel version 1 in file in manifest", "1", mrvM);
    }
    
    public void testSpecificationVersion() throws Exception {
        //check default spec version in customizer and in file
        final String DEF_SV = "1.0";  
        JTextField sv = (JTextField) getComponent(SPECIFICATION_VERSION_NAME, SPECIFICATION_VERSION_CLASS);
        assertEquals("spec ver.should be 1.0 by default", DEF_SV, sv.getText());
        
        ManifestManager mm = ManifestManager.getInstance(getProject().getManifest(), false);
        String svM = mm.getSpecificationVersion();
        assertEquals("checking default spec. version in file", DEF_SV, svM);
        
        // set higher version, reopen customizer, check there and also in manifest
        sv.setText("2.0");
        okButton();
        openCustomizer();
        assertEquals("new version in customizer", "2.0", sv.getText());
        
        mm = ManifestManager.getInstance(getProject().getManifest(), false);
        svM = mm.getSpecificationVersion();
        assertEquals("2.0 should be in manifest", "2.0", svM);
        
    }
 
    
    public void testImplementationVersion() throws Exception {
        JTextField iv = (JTextField) getComponent(IMPLEMENTATION_VERSION_NAME, IMPLEMENTATION_VERSION_CLASS);
        assertEquals("Impl.version empty by default", "", iv.getText());

        ManifestManager mm = ManifestManager.getInstance(getProject().getManifest(), false);
        String ivM = mm.getSpecificationVersion();
        assertNull("checking default imp. version in file", ivM);
        
        iv.setText("1");
        okButton();
        openCustomizer();
        assertEquals("new i.version in cusomizer", "1", iv.getText());
        
        mm = ManifestManager.getInstance(getProject().getManifest(), false);
        ivM = mm.getImplementationVersion();
        assertEquals("i.version = 1 should be in manifest", "1", ivM);
    }
 
 
 
    
    public void testModuleType() throws Exception {
        //check if regular by deafult, select autoload and check if buttons are grouped
        JRadioButton reg = (JRadioButton) getComponent(REGULAR_NAME, MODULE_TYPE_CLASS);
        JRadioButton al = (JRadioButton) getComponent(AUTOLOAD_NAME, MODULE_TYPE_CLASS);
        JRadioButton eager = (JRadioButton) getComponent(EAGER_NAME, MODULE_TYPE_CLASS);
        assertTrue("regular by default is selected", reg.isSelected());
        
        al.setSelected(true);
        okButton();
        openCustomizer();
        assertTrue("autoload should be selected,buttons are grouped", al.isSelected() && !reg.isSelected() && !eager.isSelected());
        
        //test if change propagated into project.properies
        FileObject ProjPropFile = getProject().getProjectDirectory().getFileObject("nbproject/project.properties");
        Properties props = new Properties();
        InputStream is = ProjPropFile.getInputStream();
        props.load(is);
        is.close();
        assertEquals("autoload is in project.properties", "true", props.getProperty("is.autoload"));
        
        //select regular again
        openCustomizer();
        assertTrue("autoload still selected", al.isSelected());
        reg.setSelected(true);
        okButton();
        openCustomizer();
        assertTrue("now regular is selected", reg.isSelected());
        
        //see if last change is visible in file, it should be empty now, no properties
        Properties props2 = new Properties();
        InputStream is2 = ProjPropFile.getInputStream();
        props2.load(is2);
        is2.close();
        assertTrue("if regular=>project.properties are empty", props2.isEmpty());
    }
    
    public void testProvidedTokens() throws Exception {
        //check if empty by default in file and in customizer
        JTextField pt = (JTextField) getComponent(PROVIDED_TOKENS_NAME, PROVIDED_TOKENS_CLASS);
        assertEquals("no tokens by default", "", pt.getText());
        
        FileObject mfo = getProject().getProjectDirectory().getFileObject("manifest.mf");
        ManifestManager mm = ManifestManager.getInstance(getProject().getManifest(), false);
        String ptM = mm.getProvidedTokensString();
        assertNull("no tokens also in manifest", ptM);
        
        //set someToken, check in customizer and also in manifest
        pt.setText("someToken");
        okButton();
        openCustomizer();
        assertEquals("someToken present now in customizer", "someToken", pt.getText());
       
        mm = ManifestManager.getInstance(getProject().getManifest(), false);
        String pt2M = mm.getProvidedTokensString();
        assertEquals("someToken also present in manifest","someToken", pt2M);
    }
    
}
