/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/**
 *
 * @author pzajac, musilt2
 */

package org.netbeans.modules.apisupport.project;

import java.awt.TextField;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;


public class PCDisplayTest extends ProjectCustomizerHid {


//[ideTestRunner] Category:Display
//[ideTestRunner] AN="Display Name:"
//[ideTestRunner] CN="class javax.swing.JLabel
    private static final String DISPLAY_NAME_NAME="Display Name:";
    private static final Class DISPLAY_NAME_CLASS=javax.swing.JTextField.class;
//[ideTestRunner] AN="Display Category:"
//[ideTestRunner] CN="class javax.swing.JLabel"
    private static final String DISPLAY_CATEGORY_NAME="Display Category:";
    private static final Class DISPLAY_CATEGORY_CLASS=javax.swing.JComboBox.class;
//[ideTestRunner] AN="Short Description:"
//[ideTestRunner] CN="class javax.swing.JLabel"
    private static final String SHORT_DESCRIPTION_NAME="Short Description:";
    private static final Class SHORT_DESCRIPTION_CLASS=javax.swing.JTextField.class;
//[ideTestRunner] AN="Short Description:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Long Description:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="null"
//[ideTestRunner] CN="class javax.swing.JPanel"
    private static final String LONG_DESCRIPTION_NAME="Long Description:";
    private static final Class LONG_DESCRIPTION_CLASS=javax.swing.JTextArea.class;
//ideTestRunner] AN="Long Description:"
//[ideTestRunner] AC="class javax.swing.JTextArea"

    
    /** Creates a new instance of PCDisplayTest */
    public PCDisplayTest(String name) {
        super(name,"Display","standalone");
    }
    
    public void testDisplayName() throws Exception{
        //first,change name in customizer, see if it propagates to Bundle.properites
        final JTextField displayNameField = (JTextField)getComponent(DISPLAY_NAME_NAME,DISPLAY_NAME_CLASS);
        assertEquals("Name standalone should be present", "standalone", displayNameField.getText());
        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                displayNameField.setText("new name");
            }
        });
        FileObject propFile = getProject().getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
        QAUtil.registerFileModificate(propFile);
        okButton();
        QAUtil.waitFileModificate(propFile,new Date());
        assertEquals("New name should be set in Bundle.properties","new name", QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Name"));
        
        //now check if new name is there after opening customizer, and revert changes back
        openCustomizer();
        final JTextField dn2  = (JTextField)getComponent(DISPLAY_NAME_NAME,DISPLAY_NAME_CLASS);
        assertEquals("new should be now in customizer ", "new name", displayNameField.getText());
        dn2.setText("standalone");
        okButton();
    }
    
    public void testDisplayCategory() throws Exception{
        //check if default category is empty, then set Database category(index=1)
        JComboBox categoryCombo = (JComboBox) getComponent(DISPLAY_CATEGORY_NAME, DISPLAY_CATEGORY_CLASS);
        Object value = categoryCombo.getSelectedItem();
        // just wait till combo gets occupied
        // better to do it by code from AddModulePanelTest 
        while(value==null || value.toString().equals("Please wait...")) {
            Thread.sleep(200);
            value = categoryCombo.getSelectedItem();
        }
        assertTrue("empty category", value==null || value.toString().equals(""));
        categoryCombo.setSelectedIndex(1);
        okButton();
        openCustomizer();
        assertEquals("Database must be selected", "Database", categoryCombo.getSelectedItem().toString());
        FileObject propFile = getProject().getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
        QAUtil.registerFileModificate(propFile);
        okButton();
        QAUtil.waitFileModificate(propFile,new Date());
        openCustomizer();
        //check if written to Bundle.properties, check if persistant in customizer
        assertEquals("Must be written to Bundle","Database", QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Display-Category"));
        
        
        while(categoryCombo==null || categoryCombo.getSelectedItem().toString().equals("Please wait...")) {
            categoryCombo = (JComboBox) getComponent(DISPLAY_CATEGORY_NAME, DISPLAY_CATEGORY_CLASS);
            Thread.sleep(200);
        }
        assertEquals("still Database", "Database", categoryCombo.getSelectedItem().toString());
        
        //revert changes to empty
        categoryCombo.setSelectedIndex(0);
        assertTrue("empty category again", value==null || value.toString().equals(""));
        okButton();
    }

    
    public void testShortDescription() throws Exception{
        // test if empty by default, change it, and check in Bundle.properties
        final String sd = "this is short description";
        JTextField shortDesc = (JTextField) getComponent(SHORT_DESCRIPTION_NAME, SHORT_DESCRIPTION_CLASS);
        assertEquals("should be empty by default","", shortDesc.getText());
        shortDesc.setText(sd);
        FileObject propFile = getProject().getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
        QAUtil.registerFileModificate(propFile);
        okButton();
        QAUtil.waitFileModificate(propFile,new Date());
        assertEquals("short description present in Bundle.properties", sd, QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Short-Description"));
        
        // check if description is loaded in customizer, then delete it, confirm, and check in Bundle.properties
        openCustomizer();
        shortDesc = (JTextField) getComponent(SHORT_DESCRIPTION_NAME, SHORT_DESCRIPTION_CLASS);
        assertEquals("short description  present in customizer", sd, shortDesc.getText());
        shortDesc.setText("");
        propFile = getProject().getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
        QAUtil.registerFileModificate(propFile);
        okButton();
        QAUtil.waitFileModificate(propFile,new Date());
        assertNull("should be deleted from file", QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Short-Description"));
    }
 
      public void testLongDescription() throws Exception {
          //test defaults in customizer and in bundle.properties
          JTextArea ld = (JTextArea)getComponent(LONG_DESCRIPTION_NAME, LONG_DESCRIPTION_CLASS);
          assertEquals("l.d. by default empty", "", ld.getText());
          
          String ld_bundle = QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description");
          assertNull("not present in bundle.properties", ld_bundle);
          
          //set some long description and test its persistance in customizer and file
          final String LD = "This is a long description";
          ld.setText(LD);
          okButton();
          openCustomizer();
          assertEquals("l.d. present now in customizer", LD, ld.getText());
          ld_bundle = QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description");
          assertEquals("Long description is present in bundle", LD, ld_bundle);
          
          // revert changes, delete long description
          ld = (JTextArea) getComponent(LONG_DESCRIPTION_NAME, LONG_DESCRIPTION_CLASS);
          assertEquals("l.d. still present now in customizer", LD, ld.getText());
          ld_bundle = QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description");
          assertEquals("l.d. stil in bundle.properties", LD, ld_bundle);
          
          ld.setText("");
          okButton();
          openCustomizer();
          assertEquals("l.d. empty now", "", ld.getText());
          ld_bundle = QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description");
          assertNull("l.d.deleted from file", ld_bundle);
      }  
    
//    public void testLongDescription()throws Exception{
//        // test if empty by default, set some, and check in Bundle.properties
//        final String LD = "firstLine\n secondLine\n thirdLine\n";
//        final String LD_FINAL = "firstLine\n secondLine\n thirdLine";
//        JTextArea ld = (JTextArea)getComponent(LONG_DESCRIPTION_NAME, LONG_DESCRIPTION_CLASS);
//        assertEquals("l.d. by default empty", "", ld.getText());
//        final JTextArea jtx = ld;
//        SwingUtilities.invokeAndWait(new Runnable(){
//            public void run(){
//                jtx.setText(LD);
//            }
//        });
//        FileObject propFile = getProject().getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
//        QAUtil.registerFileModificate(propFile);
//        okButton();
//        QAUtil.waitFileModificate(propFile,new Date());
//        String LD_bundle = QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description");
//        assertEquals("l.d.should be in Bundle.properties now",LD_FINAL, LD_bundle);
//        
//        // check if loads in customizer, revert changes then and check it.
//        openCustomizer();
//        ld = (JTextArea)getComponent(LONG_DESCRIPTION_NAME, LONG_DESCRIPTION_CLASS);
//        final JTextArea ld1 = ld;
//        final String aos[] = new String[1];
//        SwingUtilities.invokeAndWait(new Runnable() {
//            public void run() {
//                aos[0] = ld1.getText();
//            }
//        });
//        String ld_text = aos[0];
//        
//        System.out.println("ld_text:"+ld_text);
//        assertEquals("l.d.should be loaded to customizer", LD_FINAL, ld_text);
//        
//        //ld.setText("");
//        SwingUtilities.invokeAndWait(new Runnable() {
//            public void run() {
//                ld1.setText("");
//            }
//        });        
//        propFile = getProject().getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
//        //QAUtil.registerFileModificate(propFile);
//        Thread.sleep(10000);
//        okButton();        
//        
//        //QAUtil.waitFileModificate(propFile,new Date());
//        System.out.println("Ld='"+ld.getText()+"'");
//        System.out.println("Ld1='"+ld1.getText()+"'");
//
//       // System.out.println("in file='"+QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description").toString()+"'");
//        assertNull("should be deleted now",QAUtil.getBundleProperties(getProject()).getProperty("OpenIDE-Module-Long-Description"));
//    }

}

