/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 * Test functionality of PCSource.
 * @author pzajac
 */
public class PCSourceTest extends ProjectCustomizerHid {
//[ideTestRunner] AN="Project Folder:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Source Level:"
//[ideTestRunner] CN="class javax.swing.JLabel"
public static final String SOURCE_LEVEL_NAME ="Source Level:";
public static Class SOURCE_LEVEL_CLASS = javax.swing.JComboBox.class;
//[ideTestRunner] CN="class javax.swing.JLabel"
private static final String PROJECT_FOLDER_NAME =  "Project Folder:";
private static final Class PROJECT_FOLDER_CLASS = javax.swing.JTextField.class;
//[ideTestRunner] AN="Module Suite:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Module Suite:"
//[ideTestRunner] CN="class javax.swing.JTextField"

 
    public PCSourceTest(String name) {
        super(name,"Sources","standalone");
    }
    
    /*
    private File scratch; // e.g.
    protected void setUp() throws Exception {
        super.setUp();
        // E.g.:
        clearWorkDir();
        scratch = getWorkDir();
    }
    protected void tearDown() throws Exception {
        super.tearDown();
    }
     */
    
    public void testSourceLevel() throws Exception {
        JComboBox sourceCombo = (JComboBox)getComponent(SOURCE_LEVEL_NAME, SOURCE_LEVEL_CLASS);
        assertNotNull ("Null source comboBox", sourceCombo);
        assertEquals("1.4",sourceCombo.getSelectedItem().toString());
        sourceCombo.setSelectedIndex(1);
        assertEquals("1.5",sourceCombo.getSelectedItem().toString());
        okButton();
        Properties props = new Properties();
        FileObject fo = getProject().getProjectDirectory().getFileObject("nbproject/project.properties"); 
        InputStream is = fo.getInputStream();
        props.load(is);
        is.close();
        assertEquals("1.5",props.getProperty("javac.source")); 
        
        openCustomizer();
        sourceCombo = (JComboBox) getComponent(SOURCE_LEVEL_NAME, SOURCE_LEVEL_CLASS); 
        assertEquals("1.5",sourceCombo.getSelectedItem().toString());
        sourceCombo.setSelectedIndex(0);
        assertEquals("1.4",sourceCombo.getSelectedItem().toString());
        okButton();

        props = new Properties();
        fo = getProject().getProjectDirectory().getFileObject("nbproject/project.properties"); 
        is = fo.getInputStream();
        props.load(is);
        is.close();
        assertNull(props.getProperty("javac.source")); 
    }
    
    public void testProjectFolderName() throws IOException {
        JTextField field = (JTextField) getComponent(PROJECT_FOLDER_NAME,PROJECT_FOLDER_CLASS);
        FileObject fobj = FileUtil.toFileObject(new File(field.getText()));
        assertEquals(getProject().getProjectDirectory(),fobj);
    }
}
