/*
 * Util.java
 *
 * Created on November 7, 2005, 7:29 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.apisupport.project;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.accessibility.AccessibleContext;
import javax.swing.JScrollPane;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;

/**
 *
 * @author pzajac
 */
public class QAUtil {
    private static Map changedFiles = new HashMap() ;
    
    private static QAFileChangeListener fileChangeListener;
    
    public static void showComponents(Component component) {
        if (component instanceof Container) {
            Component components [] = ((Container)component).getComponents();
            for (int fIt = 0 ; fIt < components.length ; fIt++) {
                showComponents(components[fIt]);
            }
        } else if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane) component;
            showComponents(scrollPane.getViewport().getView());
            Component components[] = scrollPane.getComponents();
            for (int cIt = 0 ; cIt < components.length ; cIt++) {
                showComponents(components[cIt]);
            }
        }
        System.out.println("AN=\"" + component.getAccessibleContext().getAccessibleName() + "\"");
        System.out.println("AC=\"" + component.getClass() + "\"");
    }
    
    public static  void getComponents(Component component, String accesibleName, Class clazz, List matches) {
        if (component != null) {
            if (component instanceof Container) {
                Component components [] = ((Container)component).getComponents();
                for (int fIt = 0 ; fIt < components.length ; fIt++) {
                    getComponents(components[fIt],accesibleName,clazz,matches);
                }
            } else if (component instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane) component;
                getComponents(scrollPane.getViewport().getView(),accesibleName,clazz,matches);
                Component components[] = scrollPane.getComponents();
                for (int cIt = 0 ; cIt < components.length ; cIt++) {
                    getComponents(components[cIt],accesibleName,clazz,matches);
                }
            }
            AccessibleContext context = component.getAccessibleContext();
            if (context != null) {
                String an = context.getAccessibleName();
                if (an != null && an.equals(accesibleName) && clazz == component.getClass()) {
                    matches.add(component);
                }
            }
        }
    }
    public static Component getComponent(Component component,String accesibleName,Class clazz,int index ) {
        ArrayList/*<Component>*/ results = new ArrayList();
        getComponents(component,accesibleName,clazz,results);
        return (results.size() > index) ? (Component) results.get(index) : null;
    }
    
    public static void registerFileModificate(FileObject fileObject) {
        fileObject.addFileChangeListener(getFileChangeListener());
    }
    
    public static void unRegisterFileModificate(FileObject fo) {
        fo.removeFileChangeListener(getFileChangeListener());
    }
    
    
    private static FileChangeListener getFileChangeListener() {
        if (fileChangeListener == null) {
            fileChangeListener = new QAFileChangeListener();
        }
        return fileChangeListener;
    }
    
    public static void waitFileModificate(FileObject fileObject, Date nowDate) throws InterruptedException {
        synchronized (changedFiles) {
            while (true) {
                Date changedDate = (Date) changedFiles.get(fileObject);
                if (changedDate != null && changedDate.compareTo(nowDate) > 0) {
                    System.out.println("wait for modification: " + fileObject.getPath() + ", " + nowDate.toString());
                    changedFiles.wait();
                } else {
                    return ;
                }
            }
        }
        
    }
    
    private static class QAFileChangeListener extends FileChangeAdapter {
        public void fileChanged(FileEvent fe) {
            synchronized (changedFiles) {
                Date date = new Date();
                System.out.println("modified file:" + fe.getFile().getPath() + "," + date.toString());
                changedFiles.put(fe.getFile(),date);
                changedFiles.notifyAll();
                //Thread.dumpStack();
            }
        }
    }
    
    public static final Properties getBundleProperties(Project project)throws IOException{
        FileObject propFile = project.getProjectDirectory().getFileObject("src/standalone/Bundle.properties");
        Properties props = new Properties();
        InputStream is = propFile.getInputStream();
        props.load(is);
        is.close();
        return props;
    }
    
    
    
    
    
}
