/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.project;

import java.awt.Component;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.netbeans.modules.apisupport.project.ui.TestUIUtil;

/**
 *
 * @author pzajac
 */
public class TestUIUtilImpl extends TestUIUtil {
    WeakHashMap map = new WeakHashMap();
    
    TreeSet names = new TreeSet();
    /** Creates a new instance of TestUIUtilImpl */
    public TestUIUtilImpl() {
    }

    synchronized protected void componentRegistered(Component component, String name) {
        name = name.intern();
        map.put(name,component);
        System.out.println("registered component:" + name  );
        if (names.contains(name)) {
            notifyAll();
        }
    }
    
    public Component getComponent(String name) {
        return (Component)map.get(name);
    }
    
    synchronized Component waitToComponent(String name) throws InterruptedException {
       name = name.intern();
       Component component = getComponent(name);
       if (component == null) {
           names.add(name);
           while ((component = getComponent(name)) == null) {
               System.out.println("wait to component:" + name);
                wait();
           }
           names.remove(name);
       }
       return component;
    } 
}
