/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.project.ui;

import java.awt.Component;
import org.openide.util.Lookup;

/**
 * Purpose: 
 * Used to send informations to QA functional UI test about created components. 
 * @author pzajac
 */
public abstract  class TestUIUtil {
    private static TestUIUtil cachedUIUtil;
    private static boolean bInitialized;
    
    /** Add token dialog reference name 
     */
    public static final String ADD_TOKEN_DIALOG = "ADD_TOKEN_DIALOG";

    /** Edit module dependency reference dialog name 
     */
    public static final String EDIT_MODULE_DEPENDENCY_DIALOG = "EDIT_MODULE_DEPENDENCY_DIALOG";

    /** Add module dependency dialog name 
     */
    public static final String ADD_MODULE_DEPENDENCY_DIALOG = "ADD_MODULE_DEPENDENCY_DIALOG";

    /** SPI for registering component
     */
    protected abstract void componentRegistered(Component component,String name);
  
    /** notify about created component
     */
    public  static void registerComponent(Component component,String name) {
        TestUIUtil testUtil = getDefault();
        if (testUtil != null ) {
            testUtil.componentRegistered(component,name);   
        } 
    }
    
    private static TestUIUtil getDefault() {
        if (!bInitialized) {
            cachedUIUtil = (TestUIUtil) Lookup.getDefault().lookup(TestUIUtil.class);
        }
        bInitialized = true;
        return cachedUIUtil;
    }
    
}
