/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.myorg.feedreader;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/**
 * A top component with an embedded JEditorPane based HTML browser.
 */
final class BrowserTopComponent extends TopComponent {
    
    /** The cache of opened browser components. */
    private static Map browserComponents = new HashMap();
    
    private final JScrollPane scrollPane;
    private final JEditorPane editorPane;
    
    private final String title;
    private String url;
    
    private BrowserTopComponent(String title) {
        this.title = title;
        setName(title);
        setToolTipText(NbBundle.getMessage(BrowserTopComponent.class, "HINT_BrowserTopComponent"));
        
        scrollPane = new javax.swing.JScrollPane();
        editorPane = new javax.swing.JEditorPane();
        
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        
        setLayout(new java.awt.BorderLayout());
        scrollPane.setViewportView(editorPane);
        add(scrollPane, java.awt.BorderLayout.CENTER);
    }
    
    
    public static synchronized BrowserTopComponent getBrowserComponent(String title) {
        BrowserTopComponent win = (BrowserTopComponent) browserComponents.get(title);
        if (win == null) {
            win = new BrowserTopComponent(title);
            browserComponents.put(title, win);
        }
        return (BrowserTopComponent) win;
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER;
    }
    
    public void componentOpened() {
        // TODO add custom code on component opening
    }
    
    public synchronized void componentClosed() {
        browserComponents.remove(title);
    }
    
    public void setPage(String url) {
        this.url = url;
        try {
            editorPane.setPage(new URL(this.url));
        } catch (IOException ioe) {
            ErrorManager.getDefault().notify(ioe);
        }
    }
    
}
