/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.beanbrowser;

import java.awt.Component;
import java.beans.IntrospectionException;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/** Browse the selected window. */
public class BeanBrowseWindowAction extends CallableSystemAction {

    public String getName () {
        return "Bean Browse Window";
    }

    public HelpCtx getHelpCtx () {
        return new HelpCtx ("org.netbeans.modules.apisupport.beanbrowser");
    }

    public void performAction () {
        try {
            Component c = TopComponent.getRegistry ().getActivated ();
            if (c == null)
                c = WindowManager.getDefault ().getMainWindow ();
            Node n = Wrapper.make (new RefinedBeanNode (c));
            NodeOperation.getDefault ().explore (n);
        } catch (IntrospectionException e) {
            ErrorManager.getDefault ().notify (e);
        }
    }
    
    protected boolean asynchronous() {
        return false;
    }

    protected void initialize() {
        super.initialize();
        // #59995:
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
}
