/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import javax.swing.JPanel;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/** Used to let user now the web will be checked for new updates. And
 * optionally config the process
 * @author  Petr Hrebejk
 */
class AutoCheckInfo extends javax.swing.JPanel {

    private Settings settings;

    /** prefferd width of dialog */
    private int prefX = 0;

    private java.awt.Dimension prefSize = null;
    
    /** Creates new form LicencePanel */
    public AutoCheckInfo( String  message, int messageType ) {

        settings = Settings.getShared();
        int period = settings.getPeriod();

        initComponents ();

        Settings.PeriodPropertyEditor ppe = new Settings.PeriodPropertyEditor();

        String[] tags = ppe.getTags();

        for ( int i = 0; i < tags.length; i++ )
            periodComboBox.addItem( tags[i] );

        messageText.setText( message );
        iconLabel.setIcon( getIconForType( messageType ) );

        beforeCheckBox.setSelected( settings.isAskBefore() );
        negativCheckBox.setSelected( settings.isNegativeResults() );

        periodComboBox.setSelectedIndex( period );

        prefX = getPreferredSize().width;

        JPanel lPanel = new ServerPanel();        
        java.awt.GridBagConstraints gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.insets = new java.awt.Insets(12, 12, 0, 12);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
        
        extSettingsPanel.add(lPanel, gridBagConstraints4);

        configPanel.setBorder (new javax.swing.border.TitledBorder(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.configBorder")));
        extSettingsPanel.setBorder (new javax.swing.border.TitledBorder(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.additionalBorder")));

        configPanel.setVisible( false );
        extSettingsPanel.setVisible( false );

        configCheckBox.setMnemonic(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.configCheckBox.mnemonic").charAt(0));
        jLabel2.setDisplayedMnemonic(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jLabel2.mnemonic").charAt(0));
        beforeCheckBox.setMnemonic(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jCheckBox1.mnemonic").charAt(0));
        negativCheckBox.setMnemonic(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jCheckBox2.mnemonic").charAt(0));
        proxyButton.setMnemonic(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.proxyButton.mnemonic").charAt(0));

        getAccessibleContext().setAccessibleName(NbBundle.getBundle(AutoCheckInfo.class).getString("CTL_AutoCheck_Title"));
        getAccessibleContext().setAccessibleDescription(message);
        configCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.configCheckBox.text"));
        periodComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.jLabel2.text"));
        beforeCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.jCheckBox1.text"));
        negativCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.jCheckBox2.text"));
        proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AutoCheckInfo.class).getString("ACS_AutoCheckInfo.proxyButton.text"));
        messageText.getAccessibleContext().setAccessibleName(message);
        messageText.getAccessibleContext().setAccessibleDescription(message);
    }

    /** Overload getPreffered size to get a bit bigger dialog */

    public java.awt.Dimension getPreferredSize() {
        if ( prefX == 0 ) {
            return super.getPreferredSize();
        }

        //if ( prefSize == null )
        prefSize = super.getPreferredSize();
        prefSize.width = java.lang.Math.max( prefSize.width, prefX );

        return prefSize;
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        messagePanel = new javax.swing.JPanel();
        iconLabel = new javax.swing.JLabel();
        messageText = new javax.swing.JTextArea();
        configCheckBox = new javax.swing.JCheckBox();
        configPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        periodComboBox = new javax.swing.JComboBox();
        beforeCheckBox = new javax.swing.JCheckBox();
        negativCheckBox = new javax.swing.JCheckBox();
        extSettingsPanel = new javax.swing.JPanel();
        proxyButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(8, 8, 8, 8)));
        messagePanel.setLayout(new java.awt.GridBagLayout());

        iconLabel.setLabelFor(configCheckBox);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        messagePanel.add(iconLabel, gridBagConstraints);

        messageText.setEditable(false);
        messageText.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 18, 0, 0);
        messagePanel.add(messageText, gridBagConstraints);

        configCheckBox.setText(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.configCheckBox.text"));
        configCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                configButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 18, 0, 0);
        messagePanel.add(configCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(messagePanel, gridBagConstraints);

        configPanel.setLayout(new java.awt.GridBagLayout());

        jLabel2.setLabelFor(periodComboBox);
        jLabel2.setText(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jLabel2.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 0, 5);
        configPanel.add(jLabel2, gridBagConstraints);

        periodComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        configPanel.add(periodComboBox, gridBagConstraints);

        beforeCheckBox.setText(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jCheckBox1.text"));
        beforeCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                beforeCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        configPanel.add(beforeCheckBox, gridBagConstraints);

        negativCheckBox.setText(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.jCheckBox2.text"));
        negativCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                negativCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 8, 0);
        configPanel.add(negativCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(configPanel, gridBagConstraints);

        extSettingsPanel.setLayout(new java.awt.GridBagLayout());

        extSettingsPanel.setPreferredSize(new java.awt.Dimension(350, 200));
        proxyButton.setText(NbBundle.getBundle(AutoCheckInfo.class).getString("AutoCheckInfo.proxyButton.text"));
        proxyButton.setPreferredSize(new java.awt.Dimension(139, 27));
        proxyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                proxyButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 12, 0);
        extSettingsPanel.add(proxyButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(extSettingsPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void proxyButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_proxyButtonActionPerformed
        ProxyDialog.showDialog();
    }//GEN-LAST:event_proxyButtonActionPerformed

    private void periodComboBoxActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodComboBoxActionPerformed
        settings.setPeriod( periodComboBox.getSelectedIndex() );
    }//GEN-LAST:event_periodComboBoxActionPerformed

    private void negativCheckBoxActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_negativCheckBoxActionPerformed
        settings.setNegativeResults( negativCheckBox.isSelected() );
    }//GEN-LAST:event_negativCheckBoxActionPerformed

    private void beforeCheckBoxActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_beforeCheckBoxActionPerformed
        settings.setAskBefore( beforeCheckBox.isSelected() );
    }//GEN-LAST:event_beforeCheckBoxActionPerformed

    private void configButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_configButtonActionPerformed
        configPanel.setVisible( configCheckBox.isSelected() );
        extSettingsPanel.setVisible( configCheckBox.isSelected() );

        if ( getTopLevelAncestor() instanceof java.awt.Window ) {
            ((java.awt.Window)getTopLevelAncestor()).pack();
        }

    }//GEN-LAST:event_configButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox beforeCheckBox;
    private javax.swing.JCheckBox configCheckBox;
    private javax.swing.JPanel configPanel;
    private javax.swing.JPanel extSettingsPanel;
    private javax.swing.JLabel iconLabel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel messagePanel;
    private javax.swing.JTextArea messageText;
    private javax.swing.JCheckBox negativCheckBox;
    private javax.swing.JComboBox periodComboBox;
    private javax.swing.JButton proxyButton;
    // End of variables declaration//GEN-END:variables

    boolean showDialog(boolean yesNo) {
        //if ( dialog == null ) {
        DialogDescriptor dd = createDialog(yesNo);
        //}

        //dialog.invalidate();
        //dialog.pack();

        Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        dialog.show(); // will block
        dialog.setVisible(false);
        dialog.dispose();
        return yesNo ? dd.getValue() == DialogDescriptor.YES_OPTION : true ;
    }

    private DialogDescriptor createDialog(boolean yesNo) {

        DialogDescriptor dd;

        if ( yesNo ) {
            dd = new DialogDescriptor(
                     this,
                     NbBundle.getBundle(AutoCheckInfo.class).getString( "CTL_AutoCheck_Title" ),
                     true,                                                 // Modal
                     DialogDescriptor.YES_NO_OPTION,                     // Option list
                     DialogDescriptor.YES_OPTION,                          // Default
                     DialogDescriptor.BOTTOM_ALIGN,                        // Align
                     null, //new HelpCtx ( AutoCheckInfo.class ),          // Help
                     null );
        }
        else {
            dd = new DialogDescriptor(
                     this,
                     NbBundle.getBundle(AutoCheckInfo.class).getString( "CTL_AutoCheck_Title" ),
                     true,                                               // Modal
                     new Object [] { DialogDescriptor.OK_OPTION },       // Option list
                     DialogDescriptor.OK_OPTION,                         // Default
                     DialogDescriptor.BOTTOM_ALIGN,                      // Align
                     null, //new HelpCtx ( AutoCheckInfo.class ),        // Help
                     null );
            dd.setClosingOptions( null );
        }
        return dd;
    }


    /** Gets the right icon */

    private static  javax.swing.Icon getIconForType(int messageType) {
        if(messageType < 0 || messageType > 3)
            return null;
        switch(messageType) {
        case 0:
            return javax.swing.UIManager.getIcon("OptionPane.errorIcon"); // NOI18N
        case 1:
            return javax.swing.UIManager.getIcon("OptionPane.informationIcon"); // NOI18N
        case 2:
            return javax.swing.UIManager.getIcon("OptionPane.warningIcon"); // NOI18N
        case 3:
            return javax.swing.UIManager.getIcon("OptionPane.questionIcon"); // NOI18N
        }
        return null;
    }
}
