/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.util.*;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.ServiceType;
import org.openide.util.Lookup;

/** Service type representing autoupdate server
*
* @author Ales Kemr
*/
public abstract class AutoupdateType extends org.openide.ServiceType
{

    /** serialVersionUID */
    static final long serialVersionUID = 362844512378569452L;

    final static String PROP_ENABLED = "enabled";  // NOI18N
    final static String PROP_LAST_TIME_STAMP = "lastTimeStamp";  // NOI18N
    
    /** Holds value of property enabled. */
    private boolean enabled = true;
    
    /** Holds value of property lastTimeStamp. */
    private Date lastTimeStamp;
    
    static {
        if ( java.beans.PropertyEditorManager.findEditor( ServiceType.class ) != null )
            java.beans.PropertyEditorManager.registerEditor( 
                AutoupdateType.class, 
                java.beans.PropertyEditorManager.findEditor( ServiceType.class ).getClass()
            );
    }
    
    public AutoupdateType() {
    }

    /** @return human presentable name */
    public String displayName() {
        return NbBundle.getBundle( AutoupdateType.class).getString("CTL_Settings_Name");
    }

    public HelpCtx getHelpCtx () {
        return null;
    }

    public abstract Updates connectForUpdates();        
    
    /** Get all registered autoupdate types.
    * @return enumeration of <code>autoupdateType</code>s
    */
    public static Enumeration autoupdateTypes () {
        Collection col = Lookup.getDefault ().lookup ( new Lookup.Template( AutoupdateType.class ) ).allInstances();
        Iterator it = col.iterator();
        java.util.List lst = new ArrayList();
        while ( it.hasNext() ) {
            AutoupdateType at = (AutoupdateType)it.next();
            if (at instanceof XMLAutoupdateType) {
                // don't add a unvalid XMLAutoupdateType
                if (((XMLAutoupdateType) at).isValid ()) {
                    lst.add (at);
                }
            } else {
                // other types are added as default
                lst.add (at);
            }
        }
        return Collections.enumeration( lst );
    }

    /** Find the
    * autoupdate type implemented as a given class, among the services registered to the
    * system.
    * <P>
    * This should be used during (de-)serialization
    * of the specific autoupdate type for a data object: only store its class name
    * and then try to find the autoupdate implemented by that class later.
    *
    * @param clazz the class of the autoupdate type looked for
    * @return the desired autoupdate type or <code>null</code> if it does not exist
    */
    public static AutoupdateType find (Class clazz) {
        return (AutoupdateType) Lookup.getDefault ().lookup ( AutoupdateType.class );
    }

    /** Find the
    * autoupdate with requested name, among the services registered to the
    * system.
    * <P>
    * This should be used during (de-)serialization
    * of the specific autoupdate type for a data object: only store its name
    * and then try to find the debugger later.
    *
    * @param name (display) name of autoupdate to find
    * @return the desired autoupdate or <code>null</code> if it does not exist
    */
    public static AutoupdateType find (String name) {
        Iterator it = Lookup.getDefault ().lookup ( new Lookup.Template( AutoupdateType.class ) ).allInstances().iterator();
        while ( it.hasNext() ) {
            AutoupdateType at = (AutoupdateType)it.next();
            if ( name.equals( at.getName() ) )
                return at;
        }
        return null;
    }

    /** Gets the default autoupdate type in the system.
     * Can return null if no autoupdate types are defined.
    */
    public static AutoupdateType getDefault () {
        if (autoupdateTypes ().hasMoreElements ()) {
            return (AutoupdateType)autoupdateTypes ().nextElement ();
        } else {
            return null;
        }
    }

    /** Getter for property enabled.
     * @return Value of property enabled.
     */
    public boolean isEnabled() {
        return enabled;
    }
    
    /** Setter for property enabled.
     * @param enabled New value of property enabled.
     */
    public void setEnabled(boolean enabled) {
        boolean old = this.enabled;
        this.enabled = enabled;
        firePropertyChange( PROP_ENABLED, old ? Boolean.TRUE : Boolean.FALSE, enabled ? Boolean.TRUE : Boolean.FALSE );
    }
    
    /** Getter for property lastTimeStamp.
     * @return Value of property lastTimeStamp.
     */
    public Date getLastTimeStamp() {
        return lastTimeStamp;
    }
    
    /** Setter for property lastTimeStamp.
     * @param lastTimeStamp New value of property lastTimeStamp.
     */
    public void setLastTimeStamp(Date lastTimeStamp) {
        Date oldTime = this.lastTimeStamp;
        this.lastTimeStamp = lastTimeStamp;
        firePropertyChange (PROP_LAST_TIME_STAMP, oldTime, lastTimeStamp);
    }
    
}

