/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Image;
import java.beans.*;

import org.openide.util.NbBundle;

/** BeanInfo for Autoupdate settings
*
* @author Ales Kemr
*/
class AutoupdateTypeBeanInfo extends SimpleBeanInfo {
    
    /**
    * loads icons
    */
    public AutoupdateTypeBeanInfo() {
    }

    /** Returns the ExternalCompilerSettings' icon */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/autoupdate/resources/updateAction.gif"); // NOI18N
        } else {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/autoupdate/resources/updateAction32.gif"); // NOI18N
        }
    }
    
    public BeanInfo[] getAdditionalBeanInfo () {
        try {
            return new BeanInfo[] { Introspector.getBeanInfo (org.openide.ServiceType.class) };
        } catch (IntrospectionException ie) {
            org.openide.ErrorManager.getDefault().notify(ie);
            return null;
        }
    }
    
    public BeanDescriptor getBeanDescriptor () {
        BeanDescriptor bdesc = new BeanDescriptor (AutoupdateType.class);
        
        bdesc.setDisplayName (getBundle("CTL_AutoupdateType_Name"));
        bdesc.setValue ("version", "1.1"); // NOI18N
        return bdesc;
    }
    
    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        PropertyDescriptor[] desc = null;
        
        try {
            desc = new PropertyDescriptor[] {
                       new PropertyDescriptor("enabled", AutoupdateType.class),
                       new PropertyDescriptor("lastTimeStamp", AutoupdateType.class)
                   };

            desc[0].setDisplayName(getBundle("PROP_Enabled"));
            desc[0].setShortDescription(getBundle("HINT_Enabled"));            

            desc[1].setDisplayName(getBundle("PROP_LastTimeStamp"));
            desc[1].setShortDescription(getBundle("HINT_LastTimeStamp"));
            desc[1].setPropertyEditorClass(Settings.LastCheckPropertyEditor.class);
            desc[1].setValue("canEditAsText",Boolean.FALSE);  // NOI18N
            
            
        } catch (IntrospectionException ex) {
            //throw new InternalError ();
            ex.printStackTrace ();
        }
        return desc;
    }
    
    private String getBundle( String key ) {
        return NbBundle.getMessage( AutoupdateTypeBeanInfo.class, key );
    }
}
