/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.BorderLayout;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author Ales Kemr
 */
/*was public*/ class ConnectingDialog extends javax.swing.JPanel {

    static final int CANCEL = 1;
    static final int SKIP = 2;
    static final int OK = 0;
    
    static boolean canceled = false;
    static boolean skipped = false;
    
    private ProgressHandle progress;
    
    /** Creates new form ConnectingDialog */
    private /*was public*/ ConnectingDialog(String ucname) {
        ProgressHandle progress = ProgressHandleFactory.createHandle (getBundle ("MSG_progressHandle_name")); // NOI18N
        initComponents();
        iconLabel.setText(getBundle("CTL_Connecting_Label") // NOI18N
            + " " + ucname + "...");  // NOI18N       
        add (ProgressHandleFactory.createProgressComponent (progress), BorderLayout.SOUTH);
        progress.start ();

        getAccessibleContext().setAccessibleName(getBundle("CTL_Connecting_Title")); // NOI18N
        getAccessibleContext().setAccessibleDescription(iconLabel.getText());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        iconLabel = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout(0, 20));

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(18, 18, 18, 18)));
        iconLabel.setFont(new Font(iconLabel.getFont().getName(), Font.BOLD, iconLabel.getFont().getSize()));
        iconLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/autoupdate/resources/gears.gif")));
        iconLabel.setLabelFor(this);
        iconLabel.setText(getBundle("CTL_Connecting_Label"));
        iconLabel.setIconTextGap(16);
        add(iconLabel, java.awt.BorderLayout.CENTER);

    }
    // </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel iconLabel;
    // End of variables declaration//GEN-END:variables
    
    private static DialogDescriptor createDialog(String ucname) {

        final JButton cancelButton = new JButton(getBundle( "CTL_Connecting_Cancel" ) );
        cancelButton.setToolTipText( getBundle( "CTL_Connecting_Cancel_ToolTip" ) );
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                canceled = true;
            }
        });
        
        Enumeration ucs = AutoupdateType.autoupdateTypes ();
        assert ucs != null : "autoupdateTypes not null";
        
        int cnt = 0;
        while (cnt < 2 && ucs.hasMoreElements ()) {
            AutoupdateType at = (AutoupdateType)ucs.nextElement ();
            if (at.isEnabled ()) cnt ++;
        }
        Object[] options = null;
        Object defaultOption = cancelButton;
        if (cnt > 1) {
            final JButton skipButton = new JButton( getBundle("CTL_Connecting_Skip"));
            skipButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    skipped = true;
                }
            });
            skipButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Connecting_Skip"));
            options = new Object[] {skipButton, cancelButton};
            defaultOption = skipButton;
        } else {
            options = new Object[] {cancelButton};
        }

        DialogDescriptor dd;
        dd = new DialogDescriptor(
                 new ConnectingDialog(ucname),
                 getBundle( "CTL_Connecting_Title" ),
                 true,                                  // Modal
                 options,                               // Option list
                 defaultOption,                         // Default
                 DialogDescriptor.DEFAULT_ALIGN,        // Align
                 null,                                  // Help
                 null);

        dd.addPropertyChangeListener( new PropertyChangeListener() {
                  public void propertyChange(PropertyChangeEvent event) {
                      if (event.getPropertyName().equals(DialogDescriptor.PROP_VALUE)) {
                          Object option = event.getNewValue();
                          if (option == DialogDescriptor.CLOSED_OPTION)
                              canceled = true;
                      }
                  }
              });

        dd.setClosingOptions( null );

        return dd;
    }
    
    static void closeDialog(java.awt.Dialog dialog) {
        dialog.dispose();
    }
    
    static boolean isCanceled() {
        return canceled;
    }
    
    static boolean isSkipped() {
        return skipped;
    }
    
    static java.awt.Dialog getDialog(String ucname) {
        DialogDescriptor dd = createDialog(ucname);
        canceled = false;
        skipped = false;
        java.awt.Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        return dialog;        
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( ConnectingDialog.class, key );
    }
}

