/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

import org.openide.util.NbBundle;

class DownloadProgressPanel extends javax.swing.JPanel {

    private static final String EMPTY_STRING = ""; // NOI18N

    /** The dialog */
    private Dialog dialog;
    /** Title of the dialog */
    private String title;
    
    static final long serialVersionUID =1986287669107010921L;
    
    private Wizard.WizardPanel wizardPanel;
    
    /** Creates new form DownloadProgressPanel */
    public DownloadProgressPanel(Wizard.WizardPanel wizardPanel) {        
        this.wizardPanel = wizardPanel;
        putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2)); // NOI18N
        setName(getBundle("LBL_Download"));
        initComponents();
        
        partialLabel.setText (EMPTY_STRING);
        overallLabel.setText (EMPTY_STRING);
        extraLabel.setText (EMPTY_STRING);

        getAccessibleContext().setAccessibleName(getBundle("LBL_Download"));
        getAccessibleContext().setAccessibleDescription(getBundle("LBL_31"));
        jTextArea1.getAccessibleContext().setAccessibleName(getBundle("ACS_31"));
        jTextArea1.getAccessibleContext().setAccessibleDescription(getBundle("ACSD_31"));        
    }
    
    /** Overload getPreffered size to get a bit bigger dialog */
    public java.awt.Dimension getPreferredSize() {
        return new java.awt.Dimension( 350, super.getPreferredSize().height );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jTextArea1 = new javax.swing.JTextArea();
        partialLabel = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jProgressBar1 = new javax.swing.JProgressBar();
        overallLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jProgressBar2 = new javax.swing.JProgressBar();
        extraLabel = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jTextArea1.setBackground(partialLabel.getBackground());
        jTextArea1.setEditable(false);
        jTextArea1.setFont(new Font("Dialog", Font.PLAIN, jTextArea1.getFont().getSize()));
        jTextArea1.setLineWrap(true);
        jTextArea1.setText(getBundle("LBL_31"));
        jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jTextArea1, gridBagConstraints);

        partialLabel.setLabelFor(jPanel1);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(partialLabel, gridBagConstraints);

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setPreferredSize(new java.awt.Dimension(0, 20));
        jPanel1.add(jProgressBar1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jPanel1, gridBagConstraints);

        overallLabel.setLabelFor(jPanel2);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(overallLabel, gridBagConstraints);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel2.setPreferredSize(new java.awt.Dimension(0, 20));
        jPanel2.add(jProgressBar2, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jPanel2, gridBagConstraints);

        extraLabel.setLabelFor(this);
        org.openide.awt.Mnemonics.setLocalizedText(extraLabel, getBundle("LBL_32"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(extraLabel, gridBagConstraints);

        jButton1.setMnemonic(getBundle("BTN_Stop_Mnem").charAt(0));
        org.openide.awt.Mnemonics.setLocalizedText(jButton1, getBundle("BTN_Stop"));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(jButton1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        if (IncompleteDialog.showDialog() == IncompleteDialog.STOP)
            setExtraLabel (getBundle ("DownloadProgressPanel.jLabel1.Stop")); // NOI18N
            wizardPanel.end(false);
            jButton1.setEnabled (false);
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel extraLabel;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JProgressBar jProgressBar2;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JLabel overallLabel;
    private javax.swing.JLabel partialLabel;
    // End of variables declaration//GEN-END:variables

    private static final ResourceBundle bundle = NbBundle.getBundle("org/netbeans/modules/autoupdate/Bundle"); // NOI18N

    void setEnableStop(boolean enable) {
        jButton1.setEnabled(enable);
    }
    
    // progress components
    
    void setPartialProgressComponent (ProgressHandle partial) {
        final Component c = ProgressHandleFactory.createProgressComponent (partial);
        SwingUtilities.invokeLater (new Runnable () {
            public void run () {
                plugProgressComponent (c, jPanel1);
            }
        });
    }
    
    void setOverallProgressComponent (ProgressHandle overall) {
        final Component c = ProgressHandleFactory.createProgressComponent (overall);
        SwingUtilities.invokeLater (new Runnable () {
            public void run () {
                plugProgressComponent (c, jPanel2);
            }
        });
    }
    
    private void plugProgressComponent (Component c, JPanel p) {
        p.removeAll ();
        p.add (c, BorderLayout.CENTER);
        revalidate ();
    }
    
    /** Closes the dialog */
    public void close() {
        dialog.setVisible( false );
        dialog.dispose();
        dialog = null;
    }

    // setting labels
    public void setPartialLabel (String msg) {
        partialLabel.setText (msg);
    }

    public void setOverallLabel (String msg) {
        overallLabel.setText (msg);
    }

    public void setExtraLabel (String msg) {
        extraLabel.setText (msg);
    }
    
    // helpers

    private static String getBundle( String key ) {
        return NbBundle.getMessage( DownloadProgressPanel.class, key );
    }
}
