/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Font;
import javax.swing.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;


import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author Ales Kemr
 */
class DuplicateWarningDialog extends javax.swing.JPanel {

    static final int YES = 0;
    static final int YES_ALL = 1;
    static final int NO = 2;
    static final int NO_ALL = 3;
    
    static int result = NO;    
    
    /** Creates new form DuplicateWarningDialog */
    public DuplicateWarningDialog(String ucname) {
        initComponents();
        
        iconLabel.setText(NbBundle.getMessage( DuplicateWarningDialog.class, "MSG_DuplicateModule" ,
                           ucname )); 
        // don't use deriveFont() - see #49973 for details
        iconLabel.setFont(ResultsPanel.doDeriveFont(iconLabel.getFont(), Font.BOLD));
                           
        initAccessibility();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        iconLabel = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(18, 18, 18, 18)));
        iconLabel.setText(getBundle("MSG_DuplicateModule"));
        iconLabel.setIconTextGap(16);
        add(iconLabel, java.awt.BorderLayout.CENTER);

    }
    // </editor-fold>//GEN-END:initComponents

    private void initAccessibility(){
        getAccessibleContext().setAccessibleDescription(getBundle("ACSD_DuplicateWarning"));
        getAccessibleContext().setAccessibleName(getBundle( "CTL_Duplicate_Title" ));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel iconLabel;
    // End of variables declaration//GEN-END:variables
    
    private static DialogDescriptor createDialog(String ucname) {

        final JButton yesButton = new JButton(getBundle( "CTL_Duplicate_Yes" ) );
        yesButton.setToolTipText( getBundle( "CTL_Duplicate_Yes_ToolTip" ) );
        yesButton.setMnemonic(getBundle( "ACS_Duplicate_Yes_mnc" ).charAt(0) );
        yesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                result = YES;
            }
        });
        
        final JButton yes_allButton = new JButton(getBundle( "CTL_Duplicate_Yes_All" ) );
        yes_allButton.setToolTipText( getBundle( "CTL_Duplicate_Yes_All_ToolTip" ) );
        yes_allButton.setMnemonic(getBundle( "ACS_Duplicate_Yes_All_mnc" ).charAt(0) );
        yes_allButton.getAccessibleContext ().setAccessibleName (getBundle ("ACSN_Duplicate_Yes_All"));
        yes_allButton.getAccessibleContext ().setAccessibleDescription (getBundle ("ACSD_Duplicate_Yes_All"));
        yes_allButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                result = YES_ALL;
            }
        });
        
        final JButton noButton = new JButton(getBundle( "CTL_Duplicate_No" ) );
        noButton.setToolTipText( getBundle( "CTL_Duplicate_No_ToolTip" ) );
        noButton.setMnemonic(getBundle( "ACS_Duplicate_No_mnc" ).charAt(0) );
        noButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                result = NO;
            }
        });
        
        final JButton no_allButton = new JButton(getBundle( "CTL_Duplicate_No_All" ) );
        no_allButton.setToolTipText( getBundle( "CTL_Duplicate_No_All_ToolTip" ) );
        no_allButton.setMnemonic(getBundle( "ACS_Duplicate_No_All_mnc" ).charAt(0) );
        no_allButton.addActionListener(new java.awt.event.ActionListener() {            
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                result = NO_ALL;
            }
        });

        
               
        DialogDescriptor dd;
        dd = new DialogDescriptor(
                 new DuplicateWarningDialog(ucname),
                 getBundle( "CTL_Duplicate_Title" ),
                 true,                                  // Modal
                 new Object [] {
                     yesButton,
                     yes_allButton,
                     noButton,
                     no_allButton
                 },                                     // Option list
                 noButton,                              // Default
                 DialogDescriptor.DEFAULT_ALIGN,        // Align
                 null,                                  // Help
                 null);

        dd.addPropertyChangeListener( new PropertyChangeListener() {
                                              public void propertyChange(PropertyChangeEvent event) {
                                                  if (event.getPropertyName().equals(DialogDescriptor.PROP_VALUE)) {
                                                      Object option = event.getNewValue();
                                                      if (option == DialogDescriptor.CLOSED_OPTION)
                                                          result = NO;
                                                  }
                                              }
                                          });

        dd.setClosingOptions( null );

        return dd;
    }
    
    static void closeDialog(java.awt.Dialog dialog) {
        dialog.dispose();
    }
    
    static int getResult() {
        return result;
    }
    
    static java.awt.Dialog getDialog(String ucname) {
        DialogDescriptor dd = createDialog(ucname);
        result = NO;
        java.awt.Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        return dialog;        
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( DuplicateWarningDialog.class, key );
    }
}

