/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.io.*;
import java.util.*;
import java.util.jar.Attributes;

import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

/** Singleton creates module description for the currently installed IDE
*/
class IdeDescription extends Object  {

    private static ModuleInfo ideDescription = null;

    /** Is a singleton */
    private IdeDescription ( ) {
    }


    /** Gets the name of IDE e.g. IDE/1 */
    static String getName() {
        return Dependency.IDE_NAME;
    }

    /** Returns the description of currently */
    static ModuleInfo getIdeDescription() {

        if ( ideDescription == null ) {
            Attributes attrs = new Attributes();
            
            attrs.putValue("OpenIDE-Module", Dependency.IDE_NAME); // NOI18N
            if (Dependency.IDE_SPEC != null) {
                attrs.putValue("OpenIDE-Module-Specification-Version", Dependency.IDE_SPEC.toString()); // NOI18N
            }
            if (Dependency.IDE_IMPL != null) {
                attrs.putValue("OpenIDE-Module-Implementation-Version", Dependency.IDE_IMPL); // NOI18N
            }
            // XXX I18N...
            attrs.putValue("OpenIDE-Module-Name", "IDE Core"); // NOI18N
            
            ideDescription = new DummyModuleInfo(attrs);
        }
        return ideDescription;
    }
}
