/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Font;
import javax.swing.*;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

class IncompleteDialog extends javax.swing.JPanel {

    static final int STOP = 0;
    static final int CANCEL = 1;
    /** Result of the dialog */
    private static int result = CANCEL;

    private javax.swing.JLabel titleLabel;
    private javax.swing.JTextArea textArea;
    private javax.swing.JLabel iconLabel;

    /** Creates new form ConnectingDialog */
    public IncompleteDialog() {
        initComponents();
        initAccessibility();
        setPreferredSize(new java.awt.Dimension(350,120));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {
        iconLabel = new javax.swing.JLabel();
        titleLabel = new javax.swing.JLabel();
        textArea = new javax.swing.JTextArea();
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints;

        iconLabel.setIcon(javax.swing.UIManager.getIcon("OptionPane.warningIcon")); // NOI18N
        // don't use deriveFont() - see #49973 for details
        titleLabel.setFont(ResultsPanel.doDeriveFont(titleLabel.getFont(), Font.BOLD));
        titleLabel.setForeground(java.awt.Color.black);
        titleLabel.setText(getBundle("CTL_Incomplete_titleLabel"));

        textArea.setFont(new Font ("Dialog", Font.PLAIN, textArea.getFont().getSize()));
        textArea.setBackground(titleLabel.getBackground ());
        textArea.setDisabledTextColor(java.awt.Color.black);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setText(getBundle("CTL_Incomplete_textLabel"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new java.awt.Insets(18, 18, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(iconLabel, gridBagConstraints);

        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new java.awt.Insets(18, 12, 0, 18);
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weighty = 0.0;
        add(titleLabel, gridBagConstraints);

        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 18);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(textArea, gridBagConstraints);
    }

    private void initAccessibility(){
        getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Incomplete_Dlg" ) );
    }        
        
    private static DialogDescriptor createDialog() {

        final JButton stopButton = new JButton(getBundle( "CTL_Incomplete_Stop" ) );
        final JButton cancelButton = new JButton(getBundle( "CTL_Incomplete_Cancel" ) );

        DialogDescriptor dd;
        dd = new DialogDescriptor(
                 new IncompleteDialog(),
                 getBundle( "CTL_Incomplete_Title" ),
                 true,                                  // Modal
                 new Object [] {
                     stopButton,
                     cancelButton
                 },                                     // Option list
                 stopButton,                            // Default
                 DialogDescriptor.DEFAULT_ALIGN,        // Align
                 null, //new HelpCtx ( IncompleteDialog.class ),// Help
                 new java.awt.event.ActionListener() {
                      public void actionPerformed( java.awt.event.ActionEvent evt ) {
                          if ( evt.getSource() == stopButton )
                              result = STOP;
                          else if ( evt.getSource() == cancelButton )
                              result = CANCEL;
                      }
                 });

        dd.setClosingOptions( null );

        return dd;
    }

    static int showDialog() {
        DialogDescriptor dd = createDialog();
        java.awt.Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        dialog.setVisible (true);
        dialog.dispose();

        return result;
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( IncompleteDialog.class, key );
    }
}
