/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import java.awt.Font;
import javax.swing.JButton;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/** Panel and dialog for showing LicenceAgreement.
 * @author  Petr Hrebejk
 */
class LicenceDialog extends javax.swing.JPanel {
    
    /** Preferred size of this dialog */
    private static final java.awt.Dimension preferredSize = new java.awt.Dimension ( 620, 475 );
    
    /** The only Licence panel instance in system */
    private static LicenceDialog licencePanel;
    /** The dialog descriptor of licence dialog */
    private static DialogDescriptor dialogDescriptor = null;
    /** Is the licence accepted */
    private static boolean accepted = false;
    
    static final long serialVersionUID =-4862117522808181670L;
    /** Creates new form LicencePanel */
    public LicenceDialog () {
        initComponents ();
        
        getAccessibleContext ().setAccessibleName (getBundle ("CTL_Licence_Title"));
        getAccessibleContext ().setAccessibleDescription (getBundle ("ACS_LicenceDialog"));
        licenceTextArea.getAccessibleContext ().setAccessibleName (getBundle ("ACS_LicenceDialog_Licence"));
        licenceTextArea.getAccessibleContext ().setAccessibleDescription (getBundle ("ACSD_LicenceDialog_Licence"));
    }
    
    /** Overload getPreffered size to get a bit bigger dialog */
    public java.awt.Dimension getPreferredSize () {
        return preferredSize;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        licenceTextArea = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(8, 8, 8, 8)));
        licenceTextArea.setEditable(false);
        licenceTextArea.setFont(new Font("Monospaced", Font.PLAIN, licenceTextArea.getFont().getSize() + 1));
        jScrollPane1.setViewportView(licenceTextArea);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea licenceTextArea;
    // End of variables declaration//GEN-END:variables
    
    void setLicenceText ( String licenceText ) {
        licenceTextArea.setText ( licenceText );
        licenceTextArea.setCaretPosition (0);
        licenceTextArea.revalidate ();
    }
    
    static boolean acceptLicence ( String licenceText ) {
        createDialog (licenceText).setVisible (true);
        
        return accepted;
    }
    
    private static Dialog createDialog (String licenseText) {
        licencePanel = new LicenceDialog ();
        licencePanel.setLicenceText (licenseText);
        
        final JButton acceptButton = new JButton ( getBundle ( "CTL_Licence_Accept" ) );
        acceptButton.setMnemonic (getBundle ( "ACS_Licence_Accept_mnc" ).charAt (0) );
        final JButton declineButton = new JButton ( getBundle ( "CTL_Licence_Decline" ));
        declineButton.setMnemonic (getBundle ( "ACS_Licence_Decline_mnc" ).charAt (0) );
        
        acceptButton.getAccessibleContext ().setAccessibleDescription (getBundle ("ACS_Licence_Accept"));
        declineButton.getAccessibleContext ().setAccessibleDescription (getBundle ("ACS_Licence_Decline"));
        
        accepted = false;
        
        dialogDescriptor = new DialogDescriptor (
                licencePanel,
                getBundle ( "CTL_Licence_Title" ),
                true,                                                 // Modal
                new Object[] { acceptButton, declineButton },         // Option list
                acceptButton,                                         // Default
                        DialogDescriptor.BOTTOM_ALIGN,                        // Align
                        null,                                                 // Help
                        new java.awt.event.ActionListener () {
                    public void actionPerformed ( java.awt.event.ActionEvent evt ) {
                        accepted = evt.getSource ().equals (acceptButton);
                    }
                });
                
                dialogDescriptor.setClosingOptions (null);
                
                return DialogDisplayer.getDefault ().createDialog ( dialogDescriptor );
    }
    
    private static String getBundle ( String key ) {
        return NbBundle.getMessage ( LicenceDialog.class, key );
    }
}
