/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;

import org.openide.actions.*;
import org.openide.cookies.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.*;
import org.openide.nodes.*;
import org.openide.util.HelpCtx;

/** Represents a Nbm object in the Repository.
 *
 * @author Ales Kemr
 */
class NbmDataObject extends MultiDataObject {

    public NbmDataObject (FileObject pf, NbmDataLoader loader) throws DataObjectExistsException {
        super (pf, loader);
        init ();
    }

    private void init () {
        CookieSet cookies = getCookieSet ();
        cookies.add (new OpenCookie () {
		public void open () {
                    FileObject fo = NbmDataObject.this.getPrimaryFile();
                    File f = FileUtil.toFile( fo );
                    if ( f == null ) {
                        f = Autoupdater.Support.getTempCopyFile( fo );
                    }
                    
                    XMLUpdates.startGroupUpdates( f );
		}
	    });        
    }
    
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
        // If you add context help, change to:
        // return new HelpCtx (NbmDataObject.class);
    }

    protected Node createNodeDelegate () {
        return new NbmDataNode (this);
    }

}
