/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;


import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.openide.modules.ModuleInfo;

/** This class finds all patches in the system
 * 
 * @author  Petr Hrebejk
 */
class PatchChecker extends Object {

    private static final String JAR_EXTENSION = ".JAR"; // NOI18N
    private static final String ZIP_EXTENSION = ".ZIP"; // NOI18N

    private static ModuleInfo[] patchArray = null;

    /** The class is singleton */
    private PatchChecker() {
    }

    static ModuleInfo[] getPatches() {

        if ( patchArray == null ) {

            List/*<File>*/ patchDirectories = Autoupdater.Support.getPatchDirectories ();

            Collection patches = new ArrayList();

            if (!patchDirectories.isEmpty ()) {
                Iterator it = patchDirectories.iterator ();
                while (it.hasNext ()) {
                    addPatches ((File)it.next (), patches);
                }
            }
            
            patchArray = new ModuleInfo[ patches.size() ];
            patches.toArray( patchArray );
        }

        return patchArray;
    }

    private static void addPatches( File directory, Collection result ) {

        File dirList[] = directory.listFiles( new FilenameFilter() {
                                                  public boolean accept( File dir, String name ) {
                                                      return name.toUpperCase().endsWith( JAR_EXTENSION ) ||
                                                             name.toUpperCase().endsWith( ZIP_EXTENSION );
                                                  }
                                              });
	// Patch dir might not even exist:
	if (dirList == null) return;

        for ( int i = 0; i < dirList.length; i++ ) {

            JarFile jarFile = null;
            try {
                jarFile = new JarFile( dirList[i] );
                Manifest manifest = jarFile.getManifest();


                if ( manifest == null )
                    continue; // This is not a standard NetBeans patch

                ModuleInfo md = new DummyModuleInfo(manifest.getMainAttributes());

                Iterator it = result.iterator();
                boolean found = false;
                while( it.hasNext() ) {
                    ModuleInfo td = (ModuleInfo)it.next();

                    if ( md.getCodeNameBase().equals( td.getCodeNameBase() ) ) {
                        found = true;
                        break;
                    }

                }

                if ( !found )
                    result.add( md );
            }
            catch ( IOException e ) {
            }
            catch ( IllegalArgumentException e ) {
            }
            finally {
                try {
                    if ( jarFile != null )
                        jarFile.close();
                } catch ( IOException ie ) {                
                }
            }

        }
    }
}
