/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import javax.swing.JRadioButton;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author Jiri Rechtacek
 * @version 
 */
class ProxyDialog extends javax.swing.JPanel {
    private String detectedProxy = null;
    private boolean isDetectedProxy = true;
    /** Creates new form ProxyDialog */
    public ProxyDialog() {
        String fromSystem = System.getProperty ("netbeans.system_http_proxy");
        isDetectedProxy = fromSystem != null;
        detectedProxy = isDetectedProxy ? fromSystem : ""; // NOI18N

        initComponents ();

        hostTextField.setText (Autoupdater.getUserProxyHost ());
        portTextField.setText (Autoupdater.getUserProxyPort ());
        setProxyType (Autoupdater.getProxyType ());

        getAccessibleContext().setAccessibleDescription(getBundle("CTL_ProxyDialog_Title"));
        getAccessibleContext().setAccessibleDescription(getBundle("ACS_ProxyDialog"));
        hostTextField.getAccessibleContext().setAccessibleDescription(getBundle("ACS_ProxyDialog.hostTextField"));
        portTextField.getAccessibleContext().setAccessibleDescription(getBundle("ACS_ProxyDialog.portTextField"));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        proxyChoiceButtons = new javax.swing.ButtonGroup();
        directConnection = new javax.swing.JRadioButton();
        autoDetectProxy = new javax.swing.JRadioButton();
        manualProxy = new javax.swing.JRadioButton();
        manualSettingsPanel = new javax.swing.JPanel();
        hostLabel = new javax.swing.JLabel();
        portLabel = new javax.swing.JLabel();
        portTextField = new javax.swing.JTextField();
        hostTextField = new javax.swing.JTextField();

        proxyChoiceButtons.add (directConnection);
        if (isDetectedProxy) proxyChoiceButtons.add (autoDetectProxy);
        proxyChoiceButtons.add (manualProxy);

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(8, 8, 8, 8));
        org.openide.awt.Mnemonics.setLocalizedText(directConnection, org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("BTN_directConnection"));
        directConnection.setToolTipText(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("TT_ProxyDialog_directConnection"));
        directConnection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                directConnectionActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        add(directConnection, gridBagConstraints);
        directConnection.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("ACD_directConnection"));

        org.openide.awt.Mnemonics.setLocalizedText(autoDetectProxy, org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("BTN_autoDetectProxy"));
        autoDetectProxy.setToolTipText(org.openide.util.NbBundle.getMessage(ProxyDialog.class, "TT_ProxyDialog_autoDetectProxy", new Object[] {isDetectedProxy ? detectedProxy : NbBundle.getMessage(ProxyDialog.class, "MSG_ProxyDialog_ProxyNotFound")}));
        autoDetectProxy.setEnabled(isDetectedProxy);
        autoDetectProxy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                autoDetectProxyActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        add(autoDetectProxy, gridBagConstraints);
        autoDetectProxy.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("ACD_autoDetectProxy"));

        org.openide.awt.Mnemonics.setLocalizedText(manualProxy, org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("BTN_manualProxy"));
        manualProxy.setToolTipText(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("TT_ProxyDialog_manualProxy"));
        manualProxy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                manualProxyActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        add(manualProxy, gridBagConstraints);
        manualProxy.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("ACD_manualProxy"));

        manualSettingsPanel.setLayout(new java.awt.GridBagLayout());

        hostLabel.setLabelFor(hostTextField);
        org.openide.awt.Mnemonics.setLocalizedText(hostLabel, getBundle("ProxyDialog.hostLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        manualSettingsPanel.add(hostLabel, gridBagConstraints);
        hostLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("ACD_ProxyDialog_hostLabel"));

        portLabel.setLabelFor(portTextField);
        org.openide.awt.Mnemonics.setLocalizedText(portLabel, getBundle("ProxyDialog.portLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        manualSettingsPanel.add(portLabel, gridBagConstraints);
        portLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ProxyDialog.class).getString("ACD_ProxyDialog_portLabel"));

        portTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                portTextFieldFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                portTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        manualSettingsPanel.add(portTextField, gridBagConstraints);

        hostTextField.setColumns(30);
        hostTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hostTextFieldActionPerformed(evt);
            }
        });
        hostTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                hostTextFieldFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                hostTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 8, 0);
        manualSettingsPanel.add(hostTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 28, 10, 24);
        add(manualSettingsPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void hostTextFieldActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hostTextFieldActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_hostTextFieldActionPerformed

    private void portTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_portTextFieldFocusLost
        portTextField.select (0, 0);
    }//GEN-LAST:event_portTextFieldFocusLost

    private void portTextFieldFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_portTextFieldFocusGained
        portTextField.selectAll ();
    }//GEN-LAST:event_portTextFieldFocusGained

    private void hostTextFieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_hostTextFieldFocusLost
        hostTextField.select (0, 0);
    }//GEN-LAST:event_hostTextFieldFocusLost

    private void hostTextFieldFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_hostTextFieldFocusGained
        hostTextField.selectAll ();
    }//GEN-LAST:event_hostTextFieldFocusGained

    private void manualProxyActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_manualProxyActionPerformed
        if (((JRadioButton)evt.getSource ()).isSelected ()) {
            setProxyType (2 /* MANUAL_SET_PROXY */);
            hostTextField.requestFocus ();
        }
    }//GEN-LAST:event_manualProxyActionPerformed

    private void autoDetectProxyActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_autoDetectProxyActionPerformed
        if (((JRadioButton)evt.getSource ()).isSelected ()) {
            setProxyType (1 /* AUTO_DETECT_PROXY */);
        }
    }//GEN-LAST:event_autoDetectProxyActionPerformed

    private void directConnectionActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_directConnectionActionPerformed
        if (((JRadioButton)evt.getSource ()).isSelected ()) {
            setProxyType (0 /* DIRECT_CONNECTION */);
        }
    }//GEN-LAST:event_directConnectionActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton autoDetectProxy;
    private javax.swing.JRadioButton directConnection;
    private javax.swing.JLabel hostLabel;
    private javax.swing.JTextField hostTextField;
    private javax.swing.JRadioButton manualProxy;
    private javax.swing.JPanel manualSettingsPanel;
    private javax.swing.JLabel portLabel;
    private javax.swing.JTextField portTextField;
    private javax.swing.ButtonGroup proxyChoiceButtons;
    // End of variables declaration//GEN-END:variables

    private void setProxyType (int proxyType) {
        switch (proxyType) {
            case 0 /* DIRECT_CONNECTION */ :
                directConnection.setSelected (true);
                manualSettingsPanel.setEnabled (false);
                hostTextField.setEnabled (false);
                portTextField.setEnabled (false);
                hostLabel.setEnabled (false);
                portLabel.setEnabled (false);
                break;
            case 1 /* AUTO_DETECT_PROXY */ :
                autoDetectProxy.setSelected (true);
                manualSettingsPanel.setEnabled (false);
                hostTextField.setEnabled (false);
                portTextField.setEnabled (false);
                hostLabel.setEnabled (false);
                portLabel.setEnabled (false);
                break;
            case 2 /* MANUAL_SET_PROXY */ :
                manualProxy.setSelected (true);
                manualSettingsPanel.setEnabled (true);
                hostTextField.setEnabled (true);
                portTextField.setEnabled (true);
                hostLabel.setEnabled (true);
                portLabel.setEnabled (true);
                break;
            default: 
                assert false : "Unknown proxy type: " + proxyType;
        }
    }

    static boolean showDialog() {
        boolean result = false;

        ProxyDialog proxyPanel;

        DialogDescriptor dd = new DialogDescriptor(
                                  proxyPanel = new ProxyDialog(),
                                  getBundle( "CTL_ProxyDialog_Title" ),
                                  true,                                                 // Modal
                                  DialogDescriptor.OK_CANCEL_OPTION,                     // Option list
                                  DialogDescriptor.OK_OPTION,                          // Default
                                  DialogDescriptor.BOTTOM_ALIGN,                        // Align
                                  null, //new HelpCtx ( ProxyDialog.class ),                  // Help
                                  null );


        Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        dialog.setVisible (true);

        if ( dd.getValue() == DialogDescriptor.OK_OPTION ) {
            Autoupdater.setProxyConfiguration (
                                proxyPanel.getProxyType (),
                                proxyPanel.getUserProxyHost (),
                                proxyPanel.getUserProxyPort ());
            result = true;
        }
        
        return result;
    }
    
    String getUserProxyHost () {
        return hostTextField.getText ();
    }
    
    String getUserProxyPort () {
        return portTextField.getText ();
    }
    
    int getProxyType () {
        if (directConnection.isSelected ()) {
            return 0;
        } else if (autoDetectProxy.isSelected ()) {
            return 1;
        } else if (manualProxy.isSelected ()) {
            return 2;
        }
        
        // no button is selected
        assert false : "Any button must be selected";
        
        return 1;
    }

    private static String getBundle( String key ) {
        return NbBundle.getMessage( ProxyDialog.class, key );
    }
}