/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Image;
import java.beans.*;

import org.openide.util.NbBundle;

/** BeanInfo for Autoupdate settings
*
* @author Petr Hrebejk
*/
public class SettingsBeanInfo extends SimpleBeanInfo {
    
    /**
    * loads icons
    */
    public SettingsBeanInfo() {
    }

    /** Returns the ExternalCompilerSettings' icon */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/autoupdate/resources/updateAction.gif"); // NOI18N
        } else {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/autoupdate/resources/updateAction32.gif"); // NOI18N
        }
    }

    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        PropertyDescriptor[] desc = null;

        try {
            desc = new PropertyDescriptor[] {
                       new PropertyDescriptor("period", Settings.class),              // 0 // NOI18N
                       new PropertyDescriptor("askBefore", Settings.class),           // 1 // NOI18N
                       new PropertyDescriptor("negativeResults", Settings.class),     // 2 // NOI18N
                       new PropertyDescriptor("lastCheck", Settings.class ),          // 3 // NOI18N
                       new PropertyDescriptor("ideIdentity", Settings.class ),        // 4 // NOI18N
                       new PropertyDescriptor("acceptedNotifications", Settings.class )    // 5 // NOI18N
                   };

            desc[0].setDisplayName(getBundle("PROP_Period"));
            desc[0].setShortDescription(getBundle("HINT_Period"));
            desc[0].setPropertyEditorClass(Settings.PeriodPropertyEditor.class);

            desc[1].setDisplayName(getBundle("PROP_AskBefore"));
            desc[1].setShortDescription(getBundle("HINT_AskBefore"));

            desc[2].setDisplayName(getBundle("PROP_NegativeResuts"));
            desc[2].setShortDescription(getBundle("HINT_NegativeResults"));

            desc[3].setDisplayName(getBundle("PROP_LastCheck"));
            desc[3].setShortDescription(getBundle("HINT_LastCheck"));
            desc[3].setPropertyEditorClass(Settings.LastCheckPropertyEditor.class);
            desc[3].setValue("canEditAsText",Boolean.FALSE);  // NOI18N

            desc[4].setDisplayName (getBundle ("PROP_IDE_IDENTITY")); // NOI18N
            desc[4].setShortDescription (getBundle ("HINT_IDE_IDENTITY")); // NOI18N
            desc[4].setHidden (true);
            
            desc[5].setDisplayName (getBundle ("PROP_ACCEPTED_NOTIFICATIONS")); // NOI18N
            desc[5].setShortDescription (getBundle ("PROP_ACCEPTED_NOTIFICATIONS")); // NOI18N
            desc[5].setHidden (true);
            
        } catch (IntrospectionException ex) {
            //throw new InternalError ();
            ex.printStackTrace ();
        }
        return desc;
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( SettingsBeanInfo.class, key );
    }
}
