/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import javax.swing.JPanel;
import java.beans.*;

import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/** Setup wizard panel UI component that represents AU settings.
 * Plays role of UI for SetupWizardPanel.
 *
 * @author  akemr
 */
class SetupPanel extends javax.swing.JPanel implements PropertyChangeListener {

    private JPanel lPanel;
    
    /** Creates new form SetupPanel */
    public SetupPanel() {
        initComponents ();
        jLabel1.setDisplayedMnemonic (getBundle ("AutoCheckInfo.jLabel2.mnemonic").charAt (0));
        jLabel1.setLabelFor (periodComboBox);
        beforeCheckBox.setMnemonic (getBundle ("AutoCheckInfo.jCheckBox1.mnemonic").charAt (0));
        negativCheckBox.setMnemonic (getBundle ("AutoCheckInfo.jCheckBox2.mnemonic").charAt (0));
        setName(getBundle ("CTL_Settings_Name"));
        putClientProperty ("WizardPanel_contentData", new String[] {getName ()}); // NOI18N
        putClientProperty ("WizardPanel_contentSelectedIndex", new Integer (0));  // NOI18N
        setPreferredSize(new java.awt.Dimension(500, 300));

        String[] tags = (new Settings.PeriodPropertyEditor()).getTags();
        for ( int i = 0; i < tags.length; i++ )
            periodComboBox.addItem( tags[i] );

        beforeCheckBox.getAccessibleContext().setAccessibleDescription(getBundle("ACS_AutoCheckInfo.jCheckBox1.text"));
        negativCheckBox.getAccessibleContext().setAccessibleDescription(getBundle("ACS_AutoCheckInfo.jCheckBox2.text"));
        getAccessibleContext().setAccessibleDescription(getBundle("ACS_AutoCheckInfo"));
        periodComboBox.getAccessibleContext ().setAccessibleDescription (getBundle("ACS_AutoCheckInfo.jLabel2.text")); //NOI18N

        
        initializePanel();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        periodPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        periodComboBox = new javax.swing.JComboBox();
        checkPanel = new javax.swing.JPanel();
        beforeCheckBox = new javax.swing.JCheckBox();
        negativCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        periodPanel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(getBundle("AutoCheckInfo.jLabel2.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        periodPanel.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        periodPanel.add(periodComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(periodPanel, gridBagConstraints);

        checkPanel.setLayout(new java.awt.GridBagLayout());

        beforeCheckBox.setText(getBundle("AutoCheckInfo.jCheckBox1.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 20, 0, 0);
        checkPanel.add(beforeCheckBox, gridBagConstraints);

        negativCheckBox.setText(getBundle("AutoCheckInfo.jCheckBox2.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 0, 0);
        checkPanel.add(negativCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(checkPanel, gridBagConstraints);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel periodPanel;
    private javax.swing.JCheckBox negativCheckBox;
    private javax.swing.JCheckBox beforeCheckBox;
    private javax.swing.JPanel checkPanel;
    private javax.swing.JComboBox periodComboBox;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    /** Initialize panel from NB setting
     */
    private void initializePanel() {
        Settings settings = Settings.getShared();
        int period = settings.getPeriod();
        
        beforeCheckBox.setSelected( settings.isAskBefore() );
        negativCheckBox.setSelected( settings.isNegativeResults() );

        periodComboBox.setSelectedIndex( period );
        
        if ( lPanel != null ) remove(lPanel);
        lPanel = new ServerPanel();
        
        java.awt.GridBagConstraints gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new java.awt.Insets(12, 20, 0, 0);
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(lPanel, gridBagConstraints1);                
    }
    
    /** Initializes component from values stored in given descriptor.
     * Should be called only once, in AWT thread.
     * Called from aggregator SetupWizardPanel
     */
    public void initFromSettings(WizardDescriptor wd) {
        wd.addPropertyChangeListener(this);
        if (Boolean.TRUE.equals(wd.getProperty("initializePanel")))
            initializePanel();
    }
    
    /** Handling of property changes in node structure and setup wizard descriptor
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if ((evt.getSource() instanceof WizardDescriptor) 
            && (WizardDescriptor.PROP_VALUE.equals(evt.getPropertyName()))) {
                
            WizardDescriptor wd = (WizardDescriptor)evt.getSource();
            if (wd.getValue() == wd.FINISH_OPTION) {
                wd.removePropertyChangeListener(this);
                Settings settings = Settings.getShared();
                settings.setAskBefore( beforeCheckBox.isSelected() );
                settings.setNegativeResults( negativCheckBox.isSelected() );
                settings.setPeriod( periodComboBox.getSelectedIndex() );                
            }
        }
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( SetupPanel.class, key );
    }
}
