/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import org.openide.util.HelpCtx;
import org.openide.util.actions.*;
import org.openide.util.NbBundle;

/** Update action.
 *
 * @author Petr Hrebejk
 */
class UpdateAction extends CallableSystemAction {

    public UpdateAction() {
        putValue("noIconInMenu", Boolean.TRUE); //NOI18N
    }
    
    /** generated Serialized Version UID
     */
    static final long serialVersionUID = 1544145343804094269L;

    /** Human presentable name of the action. This should be
     * presented as an item in a menu.
     * @return the name of the action
     */
    public String getName() {
        return NbBundle.getBundle (UpdateAction.class).getString ("CTL_Update"); // "IDE Update..."
    }

    /** Help context where to find more about the action.
     * @return the help context for this action
     */
    public HelpCtx getHelpCtx() {
        return new HelpCtx (UpdateAction.class);
    }

    /** Resource name for the icon.
     * @return resource name
     */
    protected String iconResource () {
        return "org/netbeans/modules/autoupdate/resources/updateAction.gif"; // NOI18N
    }

    /** Return true if the action should be enabled in menu
     * @return True if action should be enabled.
     */
    public boolean isEnabled() {
        return true;
    }

    public boolean asynchronous() {
        return false;
    }
    
    public void performAction () {
        Wizard.go();
        //AutoChecker.doCheck();
    }

    /** For testing only */
    public static void main( String args[] ) {

        Wizard.go();
    }

}
