/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.awt.Font;
import java.io.CharConversionException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.Module;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.xml.XMLUtil;

/**
 *
 * @author  Jiri Rechtacek
 */
public class ModulesAndDescription extends javax.swing.JPanel {

    /** Creates new form ModuleListAndDescriptionPanel */
    public ModulesAndDescription (Module [] modules, String labelText) {
        initComponents ();
        
        Mnemonics.setLocalizedText (moduleListLabel, labelText);
        moduleList.setListData (modules);
        
	HTMLEditorKit htmlkit = new HTMLEditorKit ();
	// override the Swing default CSS to make the HTMLEditorKit use the
	// same font as the rest of the UI.

	// XXX the style sheet is shared by all HTMLEditorKits.  We must
	// detect if it has been tweaked by ourselves or someone else
	// (code completion javadoc popup for example) and avoid doing the
	// same thing again

	StyleSheet css = htmlkit.getStyleSheet ();

	if (css.getStyleSheets() == null) {
	    StyleSheet css2 = new StyleSheet();
	    Font f = moduleList.getFont ();
	    int size = moduleList.getFont ().getSize ();
	    css2.addRule(new StringBuffer("body { font-size: ").append(size) // NOI18N
			.append("; font-family: ").append(f.getName()).append("; }").toString()); // NOI18N
	    css2.addStyleSheet(css);
	    htmlkit.setStyleSheet(css2);
	}

	this.description.setEditorKit (htmlkit);
	if (modules.length > 0) {
	    moduleList.setSelectedIndex (0);
	}
	
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        modulesArea = new javax.swing.JScrollPane();
        moduleList = new javax.swing.JList();
        moduleListLabel = new javax.swing.JLabel();
        descriptionPane = new javax.swing.JScrollPane();
        description = new javax.swing.JEditorPane();
        descriptionLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        moduleList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        moduleList.setCellRenderer(new ModuleCellRenderer());
        moduleList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                moduleListValueChanged(evt);
            }
        });

        modulesArea.setViewportView(moduleList);
        moduleList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ModulesAndDescription.class, "ACN_ModulesAndDescription_moduleList"));
        moduleList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ModulesAndDescription.class, "ACD_ModulesAndDescription_moduleList"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        add(modulesArea, gridBagConstraints);

        moduleListLabel.setLabelFor(moduleList);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 2, 0);
        add(moduleListLabel, gridBagConstraints);

        descriptionPane.setMinimumSize(new java.awt.Dimension(400, 80));
        descriptionPane.setPreferredSize(new java.awt.Dimension(400, 80));
        description.setEditable(false);
        descriptionPane.setViewportView(description);
        description.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ModulesAndDescription.class, "ACN_ModulesAndiDescription_description"));
        description.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ModulesAndDescription.class, "ACD_ModulesAndiDescription_description"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 0);
        add(descriptionPane, gridBagConstraints);

        descriptionLabel.setLabelFor(description);
        org.openide.awt.Mnemonics.setLocalizedText(descriptionLabel, org.openide.util.NbBundle.getMessage(ModulesAndDescription.class, "LBL_ModulesAndDescription"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 2, 0);
        add(descriptionLabel, gridBagConstraints);

    }//GEN-END:initComponents

    private void moduleListValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_moduleListValueChanged
        JList l = (JList) evt.getSource ();
        Module m = (Module) l.getSelectedValue ();
        if (m != null) {
            String text;
            try {
                text = "<b>" + XMLUtil.toElementContent(m.getDisplayName()) + "</b>"; // NOI18N
                String longDesc = (String) m.getLocalizedAttribute("OpenIDE-Module-Long-Description"); // NOI18N
                if (longDesc != null) {
                    text += "<br>" + XMLUtil.toElementContent(longDesc); // NOI18N
                }
            } catch (CharConversionException e) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
                return;
            }
            description.setText(text);
            description.setCaretPosition (0);
        } else {
            description.setText (null);
        }
    }//GEN-LAST:event_moduleListValueChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane description;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JScrollPane descriptionPane;
    private javax.swing.JList moduleList;
    private javax.swing.JLabel moduleListLabel;
    private javax.swing.JScrollPane modulesArea;
    // End of variables declaration//GEN-END:variables
    
    private static final class ModuleCellRenderer extends DefaultListCellRenderer {
        ModuleCellRenderer () {}
        public Component getListCellRendererComponent (JList list, Object val, int idx, boolean sel, boolean focus) {
            return super.getListCellRendererComponent (list, ((Module)val).getDisplayName (), idx, sel, focus);
        }
    }
    
}
