/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.updatecenterwizard;

import gui.updatecenterwizard.settings.CatalogDataValues;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.junit.NbTestSuite;
 
/**
 *
 * @author Jaromir.Uhrik@Sun.Com
 */

public class R_RemoteServerUpdateCenterWizardTests extends UpdateCenterWizardTests {
    
    CatalogDataValues dataValues = null;
    /** Creates a new instance of RemoteServerUpdateCenterWizardTests */
    public R_RemoteServerUpdateCenterWizardTests(String name) {
        super(name);
    }
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        dataValues = readDataValues("R_remote_settings.xml");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new N_RemoteServerUpdateCenterWizardTests("testUnsuccessfulConnection"));
        suite.addTest(new N_RemoteServerUpdateCenterWizardTests("testSuccessfulConnection"));
        return suite;
    }
    
       /* opens Update Center wizard
        * set proxy to wrong values
        * connects to default update center
        * and the connect fails
        */
    public void testUnsuccessfulConnection() {
        
        
        WizardOperator ucwizard = null;
        
        try {
            ucwizard = openUpdateCenterWizard();
            
            //only Development Update Center will be selected
            setAllAUtypesSelected(false);
            String devUC = Bundle.getString("org.netbeans.modules.updatecenters.resources.Bundle","Services/AutoupdateType/autoupdate_xml_type.settings");
            setAUtypeSelected(devUC, true);
            
            // set proxy
            // Proxy Configuration...
            String buttonProxyConfLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "BNT_Proxy"); // NOI18N
            new JButtonOperator(ucwizard, buttonProxyConfLabel).pushNoBlock();
            // Proxy Configuration
            String proxyConfDialogTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_ProxyDialog_Title"); // NOI18N
            NbDialogOperator proxyDialog = new NbDialogOperator(proxyConfDialogTitle);
            // Use Proxy check box
            new JCheckBoxOperator(proxyDialog).setSelected(true);
            // Proxy Host: text field
            new JTextFieldOperator(proxyDialog, 0).setText("nonexisting.cache"); // NOI18N
            // Proxy Port: text field
            new JTextFieldOperator(proxyDialog, 1).setText("80809999999999999999"); // NOI18N
            proxyDialog.ok();
            // "Next >"
            ucwizard.btNext().pushNoBlock();
            // wait connecting dialog appears
            // "Connecting"
            String connectingTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Connecting_Title");
            // wait at most 60 second until connecting dialog dismiss
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000);
            new NbDialogOperator(connectingTitle).waitClosed();
            //find Error dialog
            String errorTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Error");
            new NbDialogOperator(errorTitle).close();
            ucwizard.close();
            
        } catch (JemmyException e) {
            // close Update center dialog
            if(ucwizard != null) {
                ucwizard.close();
            }
            throw e;
        }
        
    }
     /* opens Update Center wizard
     * set proxy to webcache:8080 !!! please change it correctly to your local settings, or comment the line marked with '// !!! proxy !!!'
     * connects to default update center
     */
    public void testSuccessfulConnection() {
        
        WizardOperator ucwizard = null;
        try {
            ucwizard = openUpdateCenterWizard();
            
            //only local UC created by tests will be selected
            setAllAUtypesSelected(false);
            String myUC = dataValues.getUcName();
            setAUtypeSelected(myUC, true);
            
            // set proxy
            // Proxy Configuration...
            String buttonProxyConfLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "BNT_Proxy"); // !!! proxy !!! // NOI18N
            new JButtonOperator(ucwizard, buttonProxyConfLabel).pushNoBlock(); // !!! proxy !!!
            // Proxy Configuration
            String proxyConfDialogTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_ProxyDialog_Title"); // !!! proxy !!! // NOI18N
            NbDialogOperator proxyDialog = new NbDialogOperator(proxyConfDialogTitle);// !!! proxy !!!
            // Use Proxy check box
            new JCheckBoxOperator(proxyDialog).setSelected(true);// !!! proxy !!!
            // Proxy Host: text field
            new JTextFieldOperator(proxyDialog, 0).setText(dataValues.getProxyHost());// !!! proxy !!! // NOI18N
            // Proxy Port: text field
            new JTextFieldOperator(proxyDialog, 1).setText(dataValues.getProxyPort());// !!! proxy !!! // NOI18N
            proxyDialog.ok();// !!! proxy !!!
            // "Next >"
            ucwizard.btNext().pushNoBlock();
            // wait connecting dialog appears
            // "Connecting"
            String connectingTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Connecting_Title");
            // wait at most 60 second until connecting dialog dismiss
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000);
            new NbDialogOperator(connectingTitle).waitClosed();
            //check that you are on second pane/step
            String secondStep = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "LAB_221"); //label 'Available Updates and New Modules:' is only on second pane
            new JLabelOperator(ucwizard, secondStep);
            //can close
            ucwizard.close();
            
        } catch (JemmyException e) {
            // close Update center dialog
            if(ucwizard != null) {
                ucwizard.close();
            }
            throw e;
        }
        
    }
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        //TestRunner.run(suite());
        junit.textui.TestRunner.run(suite());
    }
    
    
    
}
