/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2005 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.beans;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

import javax.jmi.reflect.JmiException;
import java.util.List;
import java.util.Iterator;
import java.util.LinkedList;

/**
 * Helper class to simplefy operation over MDR.
 */
public final class JMIUtils {
    
    /**
     * finds all methods of clazz
     * @param clazz class to query
     * @return list of methods
     * @throws JmiException
     */ 
    public static List/*<Method>*/ getMethods(ClassDefinition clazz) throws JmiException {
        assert JMIUtils.isInsideTrans();
        List features = clazz.getFeatures();
        List/*<Method>*/ methods = new LinkedList/*<Method>*/();
        for (Iterator it = features.iterator(); it.hasNext();) {
            Object f = it.next();
            if (f instanceof Method) {
                methods.add(f);
            }
        }
        return methods;
    }
    
    /**
     * finds all constructors of clazz
     * @param clazz class to query
     * @return list of constructors
     * @throws JmiException
     */ 
    public static List/*<Constructor>*/ getConstructors(ClassDefinition clazz) throws JmiException {
        assert JMIUtils.isInsideTrans();
        List features = clazz.getFeatures();
        List/*<Constructor>*/ methods = new LinkedList/*<Constructor>*/();
        for (Iterator it = features.iterator(); it.hasNext();) {
            Object f = it.next();
            if (f instanceof Constructor) {
                methods.add(f);
            }
        }
        return methods;
    }
    
    /**
     * finds all fields of clazz
     * @param clazz class to query
     * @return list of fields
     * @throws JmiException
     */ 
    public static List/*<Field>*/ getFields(JavaClass clazz) throws JmiException {
        assert JMIUtils.isInsideTrans();
        List features = clazz.getFeatures();
        List/*<Field>*/ fields = new LinkedList/*<Field>*/();
        for (Iterator it = features.iterator(); it.hasNext();) {
            Object f = it.next();
            if (f instanceof Field) {
                fields.add(f);
            }
        }
        return fields;
    }
    
    /**
     * checks if the type is kind of some primitive type
     * @param type type to query
     * @param kind ptimitive type kind
     * @return is kind or not
     * @throws JmiException
     */ 
    public static boolean isPrimitiveType(Type type, PrimitiveTypeKindEnum kind) throws JmiException {
        assert JMIUtils.isInsideTrans();
        boolean is = false;
        if (type instanceof PrimitiveType) {
            PrimitiveType ptype = (PrimitiveType) type;
            is = kind.equals(ptype.getKind());
        }
        return is;
    }
    
    /**
     * @see org.netbeans.api.mdr.MDRepository#beginTrans(boolean)
     */ 
    public static void beginTrans(boolean writeAccess) {
        JavaMetamodel.getDefaultRepository().beginTrans(writeAccess);
        transMonitor++;
    }
    
    /**
     * @see org.netbeans.api.mdr.MDRepository#endTrans(boolean)
     */ 
    public static void endTrans(boolean rollback) {
        try {
            assert transMonitor > 0;
            JavaMetamodel.getDefaultRepository().endTrans(rollback);
        } finally {
            transMonitor--;
        }
    }
    
    /**
     * @see #endTrans(boolean)
     */ 
    public static void endTrans() {
        endTrans(false);
    }
    
    /**
     * checks if mdr transaction is running; it is supposed for aseerts 
     * @return
     */ 
    public static boolean isInsideTrans() {
        return transMonitor > 0;
    }
    
    private static int transMonitor = 0;
    
    /**
     * equals types. In case some type is {@link ParameterizedType} then its definition is taken to equal.
     * This workarounds deficiency of {@link Type}.equals(). Here is example: You get type1 via
     * {@link TypeClass#resolve(String)} and type2 via {@link org.netbeans.jmi.javamodel.Field#getType()}.
     * type1 is subclass of Type but type2 is subclass of ParametrizedType.
     * <code>type1.equals(type2)</code> is <code>false</code> in all cases.
     * @param type1 type to equal
     * @param type2 type to equal
     * @return
     * @throws JmiException
     */ 
    public static boolean equalTypes(Type type1, Type type2) throws JmiException {
        if (type1==type2)
            return true;
        if (type1 == null || type2 == null) {
            return false;
        }
        type1 = type1 instanceof ParameterizedType?
                ((ParameterizedType) type1).getDefinition() : type1;
        type2 = type2 instanceof ParameterizedType?
                ((ParameterizedType) type2).getDefinition() : type2;
        
        return type1.equals(type2);
    }
}
