/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/* $Id: CustomCodeEditor.java,v 1.1.296.1 2006/06/28 21:57:56 jtulach Exp $ */

//copied from package org.netbeans.modules.form.editors;
package org.netbeans.modules.beans.beaninfo;

import org.openide.nodes.Node;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

/**
 *
 * @author  Pavel Buzek
 * @version
 */
public class CustomCodeEditor extends javax.swing.JPanel
                              implements EnhancedCustomPropertyEditor {

    private Node.Property property;

    static final long serialVersionUID =-7413680598253484271L;

    /** Creates new form CustomCodeEditor */
    public CustomCodeEditor(Node.Property property) {
        this.property = property;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        codeEditorPane = new javax.swing.JEditorPane();
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;

        codeEditorPane.setContentType("text/x-java"); // NOI18N
        try {
            String propVal = (String) property.getValue();
            if(  propVal == null )   //be carefull about null value
                propVal = "";
            codeEditorPane.setText(propVal);
        } catch (java.lang.reflect.InvocationTargetException e1) {
            e1.printStackTrace();
        } catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }

        jScrollPane1.setViewportView(codeEditorPane);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(8, 8, 8, 8);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints1);
    }

    public Object getPropertyValue() throws IllegalStateException {
        if( codeEditorPane.getText() != null && codeEditorPane.getText().length() == 0 )
            return null;
        else
            return codeEditorPane.getText();
    }

    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JEditorPane codeEditorPane;
    // End of variables declaration
}
