/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans;

import junit.framework.*;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.jar.Attributes;
import java.util.jar.Attributes.Name;
import java.util.zip.ZipEntry;
import java.io.*;
import java.net.MalformedURLException;
import java.security.*;
import java.security.cert.Certificate;
import java.util.*;

/** 
 *
 * @author Jaroslav Tulach
 */
public class AskDirectlyTest extends TestCase {
    String c;
    String g;

    CountingClassLoader cancel;

    CountingClassLoader global;
    
    TopCountingClassLoader top;

    ProxyClassLoader all;
    
    public AskDirectlyTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        c = "org.openide.util.Cancellable";
        g = "org.openide.util.datatransfer.TransferListener";
        
        top = new TopCountingClassLoader(getClass().getClassLoader().getParent());
        
        cancel = new CountingClassLoader (
            "cancel loader", getClass().getClassLoader(), top, c            
        );
        
        global = new CountingClassLoader (
            "global that delegates to cancel", getClass().getClassLoader(), cancel, g
        );

       all = new ProxyClassLoader(new ClassLoader[] { cancel, global });
    }

    public void testLoadingJDKClassDoesNotAsk() throws Exception {
        
        assertNotNull ("We can loader JDK class", all.loadClass("java.util.HashSet", true));
        
        cancel.assertQuery("No query to our loaders1", 0);
        global.assertQuery("No query to our loaders2", 0);
    }
/*    
    public void testLoadingNonExistingClassDoesNotAsk() throws Exception {
        try {
            all.loadClass("does.not.Exists", true);
            fail ("This is supposed to fail, as the class does not exists");
        } catch (ClassNotFoundException ex) {
            // ok
        }
        
        cancel.assertQuery("No query to our loaders1", 0);
        global.assertQuery("No query to our loaders2", 0);
    }

    public void testLoadingClassFromSecondCLDoesNotAsk() throws Exception {
        Class c = all.loadClass(g, true);
        assertEquals("Loaded by global loader", global, c.getClassLoader());
                
        cancel.assertQuery("No query to our loader", 0);
        global.assertQuery("Global asked once", 1);
    }
*/
    public void testLoadingClassFromFirstCLDoesNotAsk() throws Exception {
        Class c = all.loadClass(this.c, true);
        assertEquals("Loaded by cancel loader", cancel, c.getClassLoader());
                
        global.assertQuery("No query to our loader", 0);
        cancel.assertQuery("Cancel asked once", 1);
    }
/*    
    public void testLoadingAllResourcesFromSecondCLDoesNotAsk() throws Exception {
        Enumeration en = all.getResources(g.replace('.', '/') + ".class");
        assertTrue("At least one is there", en.hasMoreElements());
        URL u;
        while (en.hasMoreElements()) {
            u = (URL)en.nextElement();
        }
                
        cancel.assertQuery("No query to our loader", 0);
        global.assertQuery("Global asked once", 1);
    }

    public void testLoadingAllResourcesFromFirstCLDoesNotAsk() throws Exception {
        Enumeration en = all.getResources(c.replace('.', '/') + ".class");
        assertTrue("At least one is there", en.hasMoreElements());
        URL u;
        while (en.hasMoreElements()) {
            u = (URL)en.nextElement();
        }
                
        global.assertQuery("No query to our loader", 0);
        cancel.assertQuery("Cancel asked once", 1);
    }
    
    public void testLoadingResourceFromSecondCLDoesNotAsk() throws Exception {
        URL u = all.getResource(g.replace('.', '/') + ".class");
        assertNotNull ("Really found", u);
                
        cancel.assertQuery("No query to our loader", 0);
        global.assertQuery("Global asked once", 1);
    }

    public void testLoadingResourceFromFirstCLDoesNotAsk() throws Exception {
        URL u = all.getResource(c.replace('.', '/') + ".class");
        assertNotNull ("Really found", u);
                
        global.assertQuery("No query to our loader", 0);
        cancel.assertQuery("Cancel asked once", 1);
    }
    
    public void testLoadingFromOwnClassLoaderIsOptimizedAsWell() throws Exception {
        Class clazz = global.loadClass(g);
        assertNotNull("Class found", clazz);
        assertSame("Classloader is the right one", global, clazz.getClassLoader());
        
        global.assertQuery("One query to our loader", 1);
        cancel.assertQuery("Cancel has not been asked at all", 0);
        top.assertQuery("The VM classloader was not asked at all", 0);
    }
*/
        
    /** Counts number of queiries.
     */
    public static class CountingClassLoader extends JarClassLoaderTest.OneClassLoader {
        public int query;
        
        public void assertQuery(String msg, int cnt) {
            assertEquals(msg, cnt, query);
            query = 0;
        }
        
        public CountingClassLoader(String name, ClassLoader l, String classname) {
            this(name, l, new ClassLoader[] { l }, classname);
        }
        
        public CountingClassLoader(String name, ClassLoader l, ClassLoader l2, String classname) {
            this(name, l, new ClassLoader[] { l2 }, classname);
        }
        
        public CountingClassLoader(String name, ClassLoader l, ClassLoader l2, Set names) {
            this(name, l, new ClassLoader[] { l2 }, names);
        }
        
        public CountingClassLoader(String name, ClassLoader lc, ClassLoader[] arr, String classname) {
            this(name, lc, arr, java.util.Collections.singleton(classname));
        }
        public CountingClassLoader(String name, ClassLoader lc, ClassLoader[] arr, java.util.Set names) {
            super(name, lc, arr, names);
        }
    

        protected Class simpleFindClass(String name, String path, String pkgnameSlashes) {
            query++;
            return super.simpleFindClass(name, path, pkgnameSlashes);
        }
        protected URL findResource(String name) {
            query++;
            return super.findResource(name);
        }
    }
    /** Counts number of queiries.
     */
    public static class TopCountingClassLoader extends ClassLoader {
        public int query;
        
        public void assertQuery(String msg, int cnt) {
            assertEquals(msg, cnt, query);
            query = 0;
        }
        
        public TopCountingClassLoader(ClassLoader parent) {
            super(parent);
        }

        public URL getResource(String name) {
            query++;

            URL retValue;
            
            retValue = super.getResource(name);
            return retValue;
        }

        public InputStream getResourceAsStream(String name) {
            query++;

            InputStream retValue;
            
            retValue = super.getResourceAsStream(name);
            return retValue;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            if (!name.startsWith("java.")) {
                query++;
            }
            

            Class retValue;
            
            retValue = super.loadClass(name);
            return retValue;
        }
        

    }
}
