/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans;

import org.netbeans.junit.NbTestCase;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;

/**  
 *
 * @author Jaroslav Tulach
 */
public class Deadlock64710Test extends NbTestCase {
    private Lkp lookup;
    
    public Deadlock64710Test(String name) {
        super(name);
    }
    
    protected void setUp() throws Exception {
        System.setProperty("org.openide.util.Lookup", "org.netbeans.Deadlock64710Test$Lkp");

        Lookup l = Lookup.getDefault();
		
		ErrorManager.getDefault();
        
        if (! (l instanceof Lkp)) {
            fail("From lookup: " + l);
        }
        
        lookup = (Lkp)l;
        
        
        String c = "org.openide.util.Cancellable";
        
        lookup.query = new JarClassLoaderTest.OneClassLoader (
            "cancel loader", getClass().getClassLoader(), getClass().getClassLoader().getParent(), c            
        );
        lookup.another = new JarClassLoaderTest.OneClassLoader (
            "another loader", getClass().getClassLoader(), getClass().getClassLoader().getParent(), c            
        );
        
    }
    
    public void testProxyClassLoaderAsksForLookup() throws Exception {
        lookup.lookup(Module.class);
    }
    
    public static final class Lkp extends AbstractLookup implements Runnable {
        ProxyClassLoader query, another;
		ProxyClassLoader toAdd;
        
        public Lkp () {
            this (new org.openide.util.lookup.InstanceContent ());
        }
        
        private Lkp (org.openide.util.lookup.InstanceContent ic) {
            super (ic);
        }

        protected synchronized void beforeLookup(org.openide.util.Lookup.Template template) {
            if (query != null) {
				ProxyClassLoader p = query;
				toAdd = p;
//				query = null;
				try {
					synchronized (this) {
						RequestProcessor.getDefault().post(this);
						wait(200);
					}
					p.loadClass("java.lang.String", false);
				} catch (Exception ex) {
					fail(ex.getMessage());
				}
				return;
            }
			
        }

        public void run() {
			toAdd.append(new ClassLoader[] { another });
        }
        
        
    }
    
}
