/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.ui;

import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;


/**
 * @author Jan Jancura
 */
public abstract class ListModel extends TabbedPanelModel {

    protected ListCellRenderer    renderer;
    protected int                 layoutOrientation;
    protected boolean             useScrolls;
    protected int                 selectionMode;
    
    
    public ListModel (
        int layoutOrientation,
        boolean useScrolls,
        int selectionMode
    ) {
        this.layoutOrientation = layoutOrientation;
        this.useScrolls = useScrolls;
        this.selectionMode = selectionMode;
    }
    
    public JComponent getPanel (String category) {
        ListCellRenderer renderer = getListCellRenderer ();
        JList l = new JList (new Vector (getItems (category)));
        l.setLayoutOrientation (layoutOrientation);
        l.setCellRenderer (renderer);
        l.setSelectionMode (selectionMode);
        if (useScrolls) {
            JScrollPane scrollPane = new JScrollPane (
                l,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
            );
            scrollPane.setBorder (null);
            return scrollPane;
        }
        return l;
    }
    
    public abstract List getItems (String category);
    public ListCellRenderer getListCellRenderer () {
        return new DefaultListCellRenderer ();
    }
}





