/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.ui;


import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.border.Border;


/**
 *
 * @author Jan Jancura
 */
public class ShadowBorder implements Border {
    
    private Insets insets = new Insets (1, 1, 3, 3);
    
    
    public void paintBorder (
        Component c, 
        Graphics g, 
        int x, int y, int width, int height
    ) {
        g.setColor (SystemColor.controlDkShadow); //Color.gray);
        g.drawRect (x, y, width - 3, height - 3);
        g.setColor (SystemColor.controlShadow); //Color.lightGray);
        g.drawLine (x + 2, height - 2, width - 1, height - 2);
        g.drawLine (x + 2, height - 1, width - 1, height - 1);
        g.drawLine (width - 2, y + 2, width - 2, height - 1);
        g.drawLine (width - 1, y + 2, width - 1, height - 1);
        g.setColor (SystemColor.control);
        g.drawRect (x, height - 2, 1, 1);
        g.drawRect (width - 2, y, 1, 1);
    }

    public Insets getBorderInsets (Component c) {
        return insets;
    }

    public boolean isBorderOpaque () {
        return true;
    }
}
