/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.output;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Ales Kemr
 * @version 1.0
 */
public class FindDialogPanel extends javax.swing.JPanel {

    static final long serialVersionUID =5048678953767663114L;

    private static FindDialogPanel findPanel;
    private static java.awt.Dialog dialog = null;
    private static boolean accepted = false;
    private static JButton acceptButton;
    private Vector history = new Vector();
    
    /** Initializes the Form */
    public FindDialogPanel() {
        initComponents ();
        getAccessibleContext().setAccessibleName(NbBundle.getBundle(FindDialogPanel.class).getString("ACSN_Find"));
        getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FindDialogPanel.class).getString("ACSD_Find"));
        findWhat.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FindDialogPanel.class).getString("ACSD_Find_What"));
        findWhat.getEditor().getEditorComponent().addKeyListener( new KeyAdapter() {
            public void keyPressed(KeyEvent evt) {
                if ( evt.getKeyCode() == KeyEvent.VK_ESCAPE ) {
                    findWhat.setPopupVisible( false );
                    dialog.setVisible( false );
                }
            }
        });
        findWhat.getEditor().addActionListener( new java.awt.event.ActionListener() {
               public void actionPerformed( java.awt.event.ActionEvent evt ) {
                   acceptButton.requestFocus();
                   acceptButton.doClick();
               }
           });
       bwdSearch.getAccessibleContext().setAccessibleDescription(
           NbBundle.getMessage(FindDialogPanel.class, "ACSD_BackwardSearch"));
       matchCase.getAccessibleContext().setAccessibleDescription(
           NbBundle.getMessage(FindDialogPanel.class, "ACSD_MatchCase"));
       wholeWords.getAccessibleContext().setAccessibleDescription(
           NbBundle.getMessage(FindDialogPanel.class, "ACSD_MatchWhole"));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        findWhatLabel = new javax.swing.JLabel();
        findWhat = new javax.swing.JComboBox();
        matchCase = new javax.swing.JCheckBox();
        wholeWords = new javax.swing.JCheckBox();
        bwdSearch = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        findWhatLabel.setDisplayedMnemonic(NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_What_Mnemonic").charAt(0));
        findWhatLabel.setLabelFor(findWhat);
        findWhatLabel.setText(org.openide.util.NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_What"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 0);
        add(findWhatLabel, gridBagConstraints);

        findWhat.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 9, 10);
        add(findWhat, gridBagConstraints);

        matchCase.setMnemonic(NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Case_Mnemonic").charAt(0));
        matchCase.setText(org.openide.util.NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Case"));
        matchCase.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 0, 0);
        add(matchCase, gridBagConstraints);

        wholeWords.setMnemonic(NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Whole_Mnemonic").charAt(0));
        wholeWords.setText(org.openide.util.NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Whole"));
        wholeWords.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(wholeWords, gridBagConstraints);

        bwdSearch.setMnemonic(NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Back_Mnemonic").charAt(0));
        bwdSearch.setText(org.openide.util.NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Back"));
        bwdSearch.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 11, 0, 10);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(bwdSearch, gridBagConstraints);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JComboBox findWhat;
    protected javax.swing.JCheckBox bwdSearch;
    protected javax.swing.JCheckBox matchCase;
    protected javax.swing.JCheckBox wholeWords;
    protected javax.swing.JLabel findWhatLabel;
    // End of variables declaration//GEN-END:variables


    static FindDialogPanel showFindDialog() {
        if ( dialog == null )
            createDialog();

        accepted = false;
        findPanel.init();
        dialog.show();

        return findPanel;
    }
    
    private void init() {
        findWhat.setModel( new DefaultComboBoxModel( history ) );
        
        SwingUtilities.invokeLater( new Runnable() {
                public void run() {
                    findWhat.getEditor().getEditorComponent().requestFocus();
                    findWhat.getEditor().selectAll();
                }
        });
    }
    
    boolean isAccepted() {
        return accepted;
    }
    
    static String getPattern() {
        return findPanel != null ? (String) findPanel.findWhat.getSelectedItem() : null;
    }
    
    static boolean isMatchCase() {
        return findPanel != null ? findPanel.matchCase.isSelected() : false;
    }
    
    static boolean isWholeWordsOnly() {
        return findPanel != null ? findPanel.wholeWords.isSelected() : false;
    }
    
    static boolean isBackwardSearch() {
        return findPanel != null ? findPanel.bwdSearch.isSelected() : false;
    }

    private void updateHistory() {
        Object pattern = findWhat.getEditor().getItem();

        history.add( 0, pattern );
        for ( int i = history.size() - 1; i > 0; i-- ) {
            if ( history.get( i ).equals( pattern ) ) {
                history.remove( i );
                break;
            }
        }
    }

    private static void createDialog() {
        findPanel = new FindDialogPanel();

        acceptButton = new JButton( NbBundle.getBundle(FindDialogPanel.class).getString("BTN_Find") );
        acceptButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FindDialogPanel.class).getString("ACSD_FindBTN"));

        DialogDescriptor dialogDescriptor = new DialogDescriptor(
                               findPanel,
                               NbBundle.getBundle(FindDialogPanel.class).getString("LBL_Find_Title"),
                               true,                                                 // Modal
                               new Object[] { acceptButton, DialogDescriptor.CANCEL_OPTION }, // Option list
                               acceptButton,                                         // Default
                               DialogDescriptor.RIGHT_ALIGN,                        // Align
                               null,                                                 // Help
                               new java.awt.event.ActionListener() {
                                   public void actionPerformed( java.awt.event.ActionEvent evt ) {
                                       if ( evt.getSource() == acceptButton ) {
                                           accepted = true;
                                           findPanel.updateHistory();
                                       }
                                       else
                                           accepted = false;

                                       dialog.setVisible( false );
                                   }
                               });

        dialog = org.openide.DialogDisplayer.getDefault().createDialog( dialogDescriptor );
        dialog.getAccessibleContext().setAccessibleName(
            NbBundle.getMessage(FindDialogPanel.class, "ACSN_Find")); //NOI18N
        dialog.getAccessibleContext().setAccessibleDescription(
            NbBundle.getMessage(FindDialogPanel.class, "ACSD_Find")); //NOI18N
    }
    
}
