/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.output;

import java.awt.Image;
import java.beans.*;

import org.openide.util.Utilities;
import org.openide.ErrorManager;

/** BeanInfo for OutputSettings.
*
* @author Ian Formanek
*/
public class OutputSettingsBeanInfo extends SimpleBeanInfo {


    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
	try {
	    PropertyDescriptor[] desc  = new PropertyDescriptor[] {
                       new PropertyDescriptor (OutputSettings.PROP_TAB_SIZE, OutputSettings.class, "getTabSize", "setTabSize"), // 1 // NOI18N
                       new PropertyDescriptor (OutputSettings.PROP_HISTORY_SIZE, OutputSettings.class, "getHistorySize", "setHistorySize"), // 8 // NOI18N
                       new PropertyDescriptor (OutputSettings.PROP_REDIRECTION, OutputSettings.class, "isRedirection", "setRedirection"), // 9 // NOI18N
                       new PropertyDescriptor (OutputSettings.PROP_DIRECTORY, OutputSettings.class), // 10 // NOI18N
                   };
            desc[0].setDisplayName (OutputSettings.getString ("PROP_TAB_SIZE"));
            desc[0].setShortDescription (OutputSettings.getString ("HINT_TAB_SIZE"));
            desc[1].setDisplayName (OutputSettings.getString ("PROP_HISTORY_SIZE"));
            desc[1].setShortDescription (OutputSettings.getString ("HINT_HISTORY_SIZE"));
            desc[2].setDisplayName (OutputSettings.getString ("PROP_REDIRECTION"));
            desc[2].setShortDescription (OutputSettings.getString ("HINT_REDIRECTION"));
            desc[3].setDisplayName (OutputSettings.getString ("PROP_REDIR_LOCATION"));
            desc[3].setShortDescription (OutputSettings.getString ("HINT_REDIR_LOCATION"));
            desc[3].setValue("files", Boolean.FALSE);
            return desc;
        } catch (IntrospectionException ex) {
	    ErrorManager.getDefault().notify(ex);
	    return null;
        }
    }

    /** Returns the OutputSettings' icon */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16))
            return Utilities.loadImage("org/netbeans/core/resources/outputSettings.gif"); // NOI18N
        else
            return Utilities.loadImage("org/netbeans/core/resources/outputSettings32.gif"); // NOI18N
    }

}
