/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core;

import java.awt.BorderLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.openide.ErrorManager;

/**
 * Workaround for issue 34879 - race condition in WindowsFileChooserUI on XP
 * with JDK 1.4.  Sometimes WindowsFileChooserUI tries to create icons from
 * null images.  It is intermittent, and seems to be system dependent; for 
 * some users, the older hack of creating JFileChoosers in a loop until one
 * did not fail worked, but for other users it was simply always broken.
 * <p>
 * This class will "warm up" WindowsFileChooserUI, letting it fail a few
 * times so it gets icons loaded before the user actually tries to display
 * a file chooser.  Not pretty, but the IDE is unusable otherwise.
 * <p>
 * When we are only supporting JDK 1.5, this class can be removed - it will
 * only be called on 1.4/Windows L&F.
 *
 * @see WarmUpSupport - it is invoked from there
 * @author  Tim Boudreau
 */
class Issue38479Workaround extends JFileChooser {
    
    /** Creates a new instance of Issue38479Workaround */
    private Issue38479Workaround() {
    }
    
    public static void run() {
        JFrame jf = new JFrame();
        jf.getContentPane().setLayout(new BorderLayout());
        jf.getContentPane().add(new Issue38479Workaround());
        jf.pack(); //Trigger updateUI() without actually displaying the chooser
        jf.dispose();
    }

     public void updateUI() {
        try {
            super.updateUI();
        } catch (NullPointerException npe) {
            for (int i=0; i < 7; i++) {
                try {
                    npe = null;
                    try {
                        Thread.currentThread().sleep(100);
                    } catch (InterruptedException ie) {
                        break;
                    }
                    super.updateUI();
                    break;
                } catch (NullPointerException npe2) {
                    npe = npe2;
                }
            }
            if (npe != null) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL,
                    "Repeated failures loading file chooser UI.  All file" + //NOI18N
                    "choosers will use MetalFileChooserUI instead"); //NOI18N
                
                //Failover - have to do something - for one user who tested this
                //patch, it simply would never succeed
                UIManager.put("FileChooserUI", //NOI18N
                    "javax.swing.plaf.metal.MetalFileChooserUI"); //NOI18N
            }
        }
    }    
}
