/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.actions;

import java.awt.Color;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

import org.netbeans.core.startup.Splash;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

/** The action that shows the AboutBox.
*
* @author Ian Formanek
*/
public class AboutAction extends CallableSystemAction {
    
    public AboutAction () {
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }

    public void performAction () {
        Splash.showSplashDialog (
            org.openide.windows.WindowManager.getDefault ().getMainWindow (),
            new org.netbeans.core.ui.ProductInformationPanel (),
            getLicenseComp()
        );
    }
    
    protected boolean asynchronous() {
        return false;
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(AboutAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(AboutAction.class, "About");
    }

    /** Utility method; loads license text from About/License folder on default
     * file system and feeds it into resulting text area.
     *
     * @return Text area containing loaded license text or null if no license
     * file was found or some kind of other I/O error happenned.
     */
    /* package private for tests */ static JComponent getLicenseComp () {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject licenseFolder = fs.findResource("About/Licenses");
        if (licenseFolder == null) {
            return null;
        }

        FileObject[] foArray = licenseFolder.getChildren();
        if (foArray.length <= 0) {
            return null;
        }

        String curLicense;
        boolean isSomeLicense = false;
        StringWriter sw = new StringWriter();
        for (int i = 0; i < foArray.length; i++) {
            curLicense = loadLicenseText(foArray[i]);
            if (curLicense != null) {
                sw.write(curLicense);
                isSomeLicense = true;
            }
            // new line between multiple licenses
            if (i < foArray.length - 1) {
                sw.write("\n"); //NOI18N
            }
        }

        if (!isSomeLicense) {
            return null;
        }

        JTextArea ta = new JTextArea(sw.toString(), 4, 0);
        ta.setBorder(new EmptyBorder(5, 12, 0, 12));
        ta.setEditable(false);
        ta.setBackground(new Color(0, 27, 51)); // harcoded color to match release55 splash background
        ta.setForeground(Color.WHITE);
        ta.setFont(ta.getFont().deriveFont((float)9));
        ta.setWrapStyleWord(true);

        JScrollPane sp = new JScrollPane(ta);
        sp.setBorder(null);
        
        return sp;
    }

    /** Tries to load text stored in given file object.
     *
     * @param fo File object to retrieve text from
     * @return String containing text from the file, or null if file can't be found
     * or some kind of I/O error appeared.
     */
    private static String loadLicenseText (FileObject fo) {
        InputStream is = null;
        try {
            is = fo.getInputStream();
        } catch (FileNotFoundException ex) {
            // warning if license file not found
            String msg = MessageFormat.format(
                NbBundle.getBundle(AboutAction.class).getString("EXC_LicenseFileNotFound"),
                new Object[] { fo.getPath() }
            );
            ErrorManager em = ErrorManager.getDefault();
            em.annotate(ex, msg);
            em.notify(ErrorManager.INFORMATIONAL, ex);
            return null;
        }

        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringWriter result = new StringWriter();
        int curChar;
        try {
            // reading content of license file
            while ((curChar = in.read()) != -1) {
                result.write(curChar);
            }
        } catch (IOException ex) {
            // don't return anything if any problem during read
            String msg = MessageFormat.format(
                NbBundle.getBundle(AboutAction.class).getString("EXC_LicenseReadBroken"),
                new Object[] { fo.getPath() }
            );
            ErrorManager em = ErrorManager.getDefault();
            em.annotate(ex, msg);
            em.notify(ErrorManager.INFORMATIONAL, ex);
            return null;
        }

        return result.toString();
    }


}
