/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.perftool;

import java.text.Format;


/** Notifies about a performance event.
 *
 */
public class PerformanceEvent extends java.util.EventObject {
    
    /** Formatter for prints */
    private Format formatter;
    /** Args */
    private Object args;
    
    /** Constructs new Event object */
    public PerformanceEvent(Object source) {
        super(source);
    }
    
    /** Constructs new Event object */
    public PerformanceEvent(Object source, Format formatter, Object args) {
        super(source);
        this.formatter = formatter;
        this.args = args;
    }
    
    /** Sets formatter */
    public final void setFormatter(Format newFormat) {
        formatter = newFormat;
    }
    
    /** Gets formatter */
    public final Format getFormatter() {
        return formatter;
    }
    
    /** Sets formatter */
    public final void setArguments(Object newArguments) {
        args = newArguments;
    }
    
    /** Gets formatter */
    public final Object getArguments() {
        return args;
    }
    
    /** Overrides */
    public String toString() {
        if ((formatter != null) && (args != null)) {
            return formatter.format(args);
        } else {
            return super.toString();
        }
    }
}