/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.perftool;

import org.openide.ErrorManager;
import org.openide.util.Lookup;

/** Creates PerformanceMeter
 *
 */
public final class PerformanceMeterFactory {
    
    /** ref to an instance */
    private static PerformanceMeter instance;

    /** Getter for a PerformanceMeter */
    public static PerformanceMeter getPerformanceMeter() {
        if (instance == null) {
            String opt = System.getProperty(PerformanceMeter.NAMING_NAME);
            if (opt != null && !opt.equals(Boolean.TRUE.toString())) {
                try {
                    Class clz = Class.forName(opt, false,
                        (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
                } catch (ClassNotFoundException e) {
                    ErrorManager.getDefault().notify(ErrorManager.WARNING, e);
                    instance = PerformanceMeterImpl.getInstance();
                }
            } else {
                instance = PerformanceMeterImpl.getInstance();
            }
        }
        
        return instance;
    }
}