/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.actions;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Utilities;
import junit.framework.Assert;
import org.netbeans.junit.NbTestCase;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.xml.sax.SAXException;

/** Simple test of correct loading of license files from About/Licenses folder. 
 *
 * @author Dafe Simonek
 */
public class AboutActionTest extends NbTestCase {
    
    public AboutActionTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }
    
    public void testGetLicenseComp () throws Exception {
        UnitTestUtils.prepareTest(new String [] { "/org/netbeans/core/actions/data/testGetLicenseCompLayer.xml" });

        System.out.println("Testing loading and concatenating of multiple license files...");
        JComponent comp = AboutAction.getLicenseComp();
        assertNotNull("Component containing license/copyright is null", comp);
        assertTrue(comp instanceof JScrollPane);

        comp = (JComponent) ((JScrollPane)comp).getViewport().getView();
        assertNotNull(comp);

        assertTrue(comp instanceof JTextArea);

        String text = ((JTextArea)comp).getText();
        assertTrue(text.indexOf("first license text") != -1);
        assertTrue(text.indexOf("second license text") != -1);
    }

    
}
