/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.derby.bundled;

import java.io.File;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;

/**
 *
 * @author Andrei Badea
 */
public class DerbyModule extends ModuleInstall {
    
    private static final String INST_DIR = "db-derby-10.1.3.1-bin"; // NOI18N
    
    public void restored() {
        if (DerbySupport.getLocation().length() <= 0) {
            // this is eager, but it only runs once (when the module is installed)
            DerbySupport.setLocation(getDefaultInstallLocation());
        }
    }
    
    public void uninstalled() {
        String location = DerbySupport.getLocation();
        if (location == null) {
            return;
        }
        String defaultLocation = getDefaultInstallLocation();
        if (defaultLocation == null) {
            // but it shouldn't happen
            return;
        }
        if (unshlashify(location).equals(unshlashify(defaultLocation))) {
            DerbySupport.setLocation(null);
        }
    }
    
    private static String getDefaultInstallLocation() {
        File location = InstalledFileLocator.getDefault().locate(INST_DIR, null, false);
        return (location != null) ? location.getAbsolutePath() :  null; // NOI18N
    }
    
    private static String unshlashify(String path) {
        assert path != null;
        int slash = path.length() - 1;
        while (slash >= 0) {
            if (path.charAt(slash) == File.separatorChar) {
                path = path.substring(0, slash);
                slash--;
            } else {
                break;
            }
        }
        return path;
    }
}
