/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.db.explorer;

import java.text.MessageFormat;

import org.openide.util.NbBundle;

/** Command is not supported by system.
* System is not able to locate appropriate resources to create a command.
* It cannot find relevant section in definition file, cannot allocate or
* initialize command object. 
*/
public class CommandUnachievableException extends Exception {
    
    /** Unsuccessfull command */
    private String cmd;

    /** Creates new exception
    * @param command The text describing the exception
    */
    public CommandUnachievableException (String command) {
        super ();
        cmd = command;
    }

    /** Creates new exception with text specified string.
    * @param command Executed command
    * @param desc The text describing the exception
    */
    public CommandUnachievableException (String command, String desc) {
        super (desc);
        cmd = command;
    }

    /** Returns executed command */
    public String getCommand() {
        return cmd;
    }

    public String toString() {
        String message = MessageFormat.format(
                NbBundle.getBundle("org.netbeans.modules.db.resources.Bundle").
                getString("ERR_UnableToPerformCommand"), new String[] {cmd, getMessage()}); // NOI18N

        return message;
    }
}
