/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.debugger.jpda.test;

import org.netbeans.spi.debugger.jpda.EditorContext;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * A simple (rather empty) implementation of ContextProvider for unit tests.
 *
 * @author Maros Sandor
 */
public class TestContextProvider extends EditorContext {

    private String          sourceRoot = System.getProperty ("test.dir.src");
    private PropertyChangeSupport pcs;

    public TestContextProvider() {
        pcs = new PropertyChangeSupport (this);
    }

    public boolean showSource(String url, int lineNumber, Object timeStamp) {
        return false;
    }
    
    public void createTimeStamp (Object timeStamp) {
    }

    public void disposeTimeStamp (Object timeStamp) {
    }
    
    public void updateTimeStamp (Object timeStamp, String url) {
    }

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return null;
    }

    public void removeAnnotation(Object annotation) {
    }
    
    public int getLineNumber (Object annotation, Object timeStamp) {
        return -1;
    }

    public int getCurrentLineNumber() {
        return -1;
    }

    public String getCurrentClassName() {
        return "";
    }

    public String getCurrentURL() {
        return "";
    }

    public String getCurrentMethodName() {
        return "";
    }

    public String getCurrentFieldName() {
        return null;
    }

    public String getSelectedIdentifier() {
        return null;
    }

    public String getSelectedMethodName() {
        return "";
    }

    public int getFieldLineNumber(String url, String className, String fieldName) {
        return -1;
    }
    
    public String getClassName (
        String url, 
        int lineNumber
    ) {
        if (!url.startsWith (sourceRoot)) return null;
        url = url.substring (sourceRoot.length ());
        int i = url.lastIndexOf ('.');
        if (i > 0)
            url = url.substring (0, i);
        url = url.replace ('/', '.');
        return url;
    }

    public String[] getImports(String url) {
        return new String[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        pcs.addPropertyChangeListener (l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        pcs.removePropertyChangeListener (l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        pcs.addPropertyChangeListener (propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        pcs.removePropertyChangeListener (propertyName, l);
    }
}
