/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.diff;

import java.awt.Rectangle;
import javax.swing.*;

/**
 * DiffView can implement this additional interface
 * to allow its nesting and management by
 * a parent container.
 *
 * @author Petr Kuzel
 */
public interface NestableDiffView {

    /**
     * Instruct view to hide its scrolling features,
     * it'll hosted by passed pane.
     */
    public void joinScrollPane(JScrollPane pane);

    /**
     * Gets raw component width, bypassing
     * its scrolling features.
     */
    public int getInnerWidth();

    /**
     * Sets view component width.
     */
    public void setInnerWidth(int width);

    /**
     * Instruct component's scrolling feature
     * to scroll to given versical position.
     */
    public void setHorizontalPosition(int pos);

    /**
     * Return y-position in view coordinate system.
     */
    public int getChangeY(int change);

    /** From Scrollable */
    public int getInnerScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction);

    /** From Scrollable */
    public int getInnerScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction);
}
