/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.editor.codetemplates;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

/**
 * Abbreviation expansion settings for a particular mimetype.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

final class AbbrevSettings implements LookupListener {
    
    private static final KeyStroke DEFAULT_EXPANSION_KEYSTROKE = KeyStroke.getKeyStroke(' ');
    
    private static final Map mimeType2settings = new HashMap();
    
    public static synchronized AbbrevSettings get(String mimeType) {
        AbbrevSettings settings = (AbbrevSettings)mimeType2settings.get(mimeType);
        if (settings == null) {
            settings = new AbbrevSettings(mimeType);
            mimeType2settings.put(mimeType, settings);
        }
        return settings;
    }
    
    public static KeyStroke getDefaultExpansionKeyStroke() {
        return DEFAULT_EXPANSION_KEYSTROKE;
    }
    
    /** MimeLookup result of code templates */
    private Lookup.Result codeTemplateSettingsLookupResult;
    
//    private Lookup.Result keyBindingSettingsLookupResult;

    private KeyStroke expandKeyStroke;
    

    AbbrevSettings(String mimeType) {
        MimeLookup mimeLookup = MimeLookup.getMimeLookup(mimeType);

        codeTemplateSettingsLookupResult = mimeLookup.lookup(
                new Lookup.Template(CodeTemplateSettings.class));
        codeTemplateSettingsLookupResult.addLookupListener(
                (LookupListener)WeakListeners.create(LookupListener.class, this, mimeLookup));

/*
        keyBindingSettingsLookupResult = mimeLookup.lookup(
                new Lookup.Template(KeyBindingSettings.class));
        keyBindingSettingsLookupResult.addLookupListener(
                (LookupListener)WeakListeners.create(LookupListener.class, this, mimeLookup));
 */

        resultChanged(null); // populate the cached value
    }
    
    public KeyStroke getExpandKeyStroke() {
	// #68528 - Temporary solution is to take the expansion keystroke
	KeyStroke eks = org.netbeans.modules.editor.options.BaseOptions.getCodeTemplateExpandKey();
	if (eks == null) {
	    eks = getDefaultExpansionKeyStroke();
	}
	eks = patchExpandKeystroke(eks);
        return eks;
    }

    public String getExpandKeyStrokeText() {
        KeyStroke expandKeyStroke = getExpandKeyStroke();
        String expandKeyStrokeText;
        if (expandKeyStroke.equals(KeyStroke.getKeyStroke(' '))) {
            expandKeyStrokeText = "SPACE"; // NOI18N
        } else if (expandKeyStroke.equals(KeyStroke.getKeyStroke(new Character(' '), InputEvent.SHIFT_MASK))) {
            expandKeyStrokeText = "Shift-SPACE"; // NOI18N
        } else if (expandKeyStroke.equals(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0))) {
            expandKeyStrokeText = "TAB"; // NOI18N
        } else if (expandKeyStroke.equals(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0))) {
            expandKeyStrokeText = "ENTER"; // NOI18N
        } else {
            expandKeyStrokeText = expandKeyStroke.toString();
        }
        return expandKeyStrokeText;
    }

    public void resultChanged(LookupEvent ev) {
	// #68528 - Temporary solution is to take the expansion keystroke
	// from BaseOptions every time when asked so the following code is inactive

	/* The following way of getting the result is not implemented yet.
	KeyStroke eks = null;
        Iterator it = codeTemplateSettingsLookupResult.allInstances().iterator();
        if (it.hasNext()) {
	    CodeTemplateSettings cts = (CodeTemplateSettings)it.next();
            eks = cts.getExpandKey();
        }
	 */

	/*
	if (eks == null) {
            eks = getDefaultExpansionKeyStroke();
        }
	 */
    }

    private KeyStroke patchExpandKeystroke(KeyStroke eks) {
	// Patch the keyPressed => keyTyped to prevent insertion of expand chars into editor
        if (eks.equals(KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 0))) {
            eks = KeyStroke.getKeyStroke(' ');
        } else if (eks.equals(KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, InputEvent.SHIFT_MASK))) {
            eks = KeyStroke.getKeyStroke(new Character(' '), InputEvent.SHIFT_MASK);
        } else if (eks.equals(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0))) {
        } else if (eks.equals(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0))) {
        }
	return eks;
    }
    
    

}
