/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import java.util.EventListener;

/**
 * Listener for begining and end of the atomic
 * locking. It can be used to optimize the document
 * listeners if a large amounts of edits are performed
 * in an atomic change. For example if there's
 * a timer restarted after each document modification
 * to update an external pane showing the document structure
 * after 2000ms past the last modification occurred
 * then there could be a following listener used:<PRE>
 *  class MultiListener implements DocumentListener, AtomicLockListener {
 *
 *    private boolean atomic; // whether in atomic change
 *
 *    public void insertUpdate(DocumentEvent evt) {
 *      modified(evt);
 *    }
 *
 *    public void removeUpdate(DocumentEvent evt) {
 *      modified(evt);
 *    }
 *
 *    public void changedUpdate(DocumentEvent evt) {
 *    }
 *
 *    private void modified(DocumentEvent evt) {
 *      if (!atomic) {
 *        restartTimer(); // restart the timer
 *      }
 *    }
 *
 *    public void atomicLock(AtomicLockEvent evt) {
 *      atomic = true;
 *    }
 *
 *    public void atomicUnlock(AtomicLockEvent evt) {
 *      atomic = false;
 *    }
 *
 *  }
 *  <PRE>
 */
public interface AtomicLockListener extends EventListener {

    public void atomicLock(AtomicLockEvent evt);
    
    public void atomicUnlock(AtomicLockEvent evt);
    
}
