/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/**
* Position in document. This is enhanced version of 
* Swing <CODE>Position</CODE> interface. It supports
* insert after feature. If Position has
* <CODE>insertAfter</CODE> flag set and text is inserted
* right at the mark's position, the position will NOT move.
*
* @author Miloslav Metelka
* @version 1.00
*/

class BasePosition implements Position {

    /** The mark that serves this position */
    private MultiMark mark;

    BasePosition(MultiMark mark) throws BadLocationException {
        this.mark = mark;
    }

    /** Get offset in document for this position */
    public int getOffset() {
        return mark.getOffset();
    }

    /** Remove mark in finalize method */
    protected void finalize() throws Throwable {
        if (mark != null)
            mark.dispose();
        super.finalize();
    }

}
