/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

/**
* Base implementation of the token category.
*
* @author Miloslav Metelka
* @version 1.00
*/

public class BaseTokenCategory implements TokenCategory {

    private final String name;

    private final int numericID;

    public BaseTokenCategory(String name) {
        this(name, 0);
    }

    public BaseTokenCategory(String name, int numericID) {
        this.name = name;
        this.numericID = numericID;
    }

    /** Get the name of the category. */
    public String getName() {
        return name;
    }

    /** Get the optional numeric identification of this token-category. It can help
    * to use the category in switch-case statements. It should default to a zero
    * if no numeric-id should be used.
    */
    public int getNumericID() {
        return numericID;
    }

    public String toString() {
        return getName();
    }

}
