/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

/**
* Base implementation of the token-id.
*
* @author Miloslav Metelka
* @version 1.00
*/

public class BaseTokenID implements TokenID {

    private final String name;

    private final int numericID;

    private final TokenCategory category;

    public BaseTokenID(String name) {
        this(name, 0);
    }

    public BaseTokenID(String name, int numericID) {
        this(name, numericID, null);
    }

    public BaseTokenID(String name, TokenCategory category) {
        this(name, 0, category);
    }

    public BaseTokenID(String name, int numericID, TokenCategory category) {
        this.name = name;
        this.numericID = numericID;
        this.category = category;
    }

    public String getName() {
        return name;
    }

    public int getNumericID() {
        return numericID;
    }

    public TokenCategory getCategory() {
        return category;
    }

    public String toString() {
        return getName() + ((getCategory() != null)
                ? (", category=" + getCategory()) : ""); // NOI18N
    }

}
